/** Basic class. Cette classe definit une strategie rudimentaire
 * pour  les fantomes
 */
public class Basic implements Strategie {

  // Direction courante
  private Position direction;

  // Direction desiree par la strategie
  private Position wanted_dir;

  // La grille afin de maintenir la coherence entre la grille et
  // la position de l'acteur
  private PacGrid grid;

  

  /** Le constructeur initialise les differents attributs
   */
  public Basic(PacGrid grid) {
    this.grid=grid;
    direction= Position.N;
    wanted_dir=direction;
    
  }

  /** Retourne la position dans la grille 
   */
 public Position move(Position pos) {
   return grid.computePosition(pos,giveDirection(pos));
 }

 /** Retourne une direction 
  */
  public Position giveDirection(Position current_pos) {
    
    if (grid.isHome(current_pos.x,current_pos.y))
    {  wanted_dir=Position.N;
    direction=wanted_dir;
    }
    else {
    if (grid.isValidPosition(current_pos.x+wanted_dir.x,current_pos.y+wanted_dir.y))
      direction=wanted_dir;
    else {setWantedDirection();
      if (!grid.isValidPosition(current_pos.x+direction.x,current_pos.y+direction.y))
	
	  direction=new Position(0,0);
	
	
    }}
    
    return direction;
  }

  /** Position la direction souhaitee aleatoirement
   */
  private void setWantedDirection() {
    int a=(int)Math.rint(Math.random()*4);
    switch (a) {
    case 0:wanted_dir=Position.N;break;
    case 1:wanted_dir=Position.S;break;
    case 2:wanted_dir=Position.W;break;
    case 3:wanted_dir=Position.E;break;
    default:
    }
  }

  /** Accesseur a l'attribut direction
   */

public char getDirection() {
	if (direction.equals(Position.N))
	return 'N';
	if (direction.equals(Position.S))
	return 'S';
	if (direction.equals(Position.E))
	return 'E';
	if (direction.equals(Position.W))
	return 'W';
	else
	return 'W';
}

}

