import java.util.*;
import java.awt.*;

/**
 * Afficheur class. Cette classe construit l'image a afficher
 * Cette classe observe la pacGrid 
 */
 
public class Afficheur implements Observer {



  // le tableau d'images du labyrinthe
  private Image pacGrid[]=new Image[5];

  // le tableau d'images des differents acteurs
  private Image acteurs[][]=new Image[12][12];
  
  private MediaTracker tracker;
  private Image gridImage;
  private Graphics gridGC;

  // Caracteristiques du labyrinthe
  private int size,nb_columns,nb_lines;
  private int widthGrid,heightGrid;

  
  private Font defaultFont= new Font("Serif",Font.BOLD,12);

  private Game game;

  /**
   * Le constructeur positionne le MediaTracker et lance le chargement 
   * des images
   */
  public Afficheur(MediaTracker tracker,Game game) {
    
    this.tracker = tracker;
    loadAllImages();
    
    this.game=game;
    
  }
  
  /** 
   * Positionne l'image ou l'on va dessiner la grille
   * L'image ne pouvant etre creer qu'une fois l'interface
   * visible on ne peut effectuer cette operation dans le
   * constructeur
   */
   public void setImage(Image gridImage) {
    this.gridImage=gridImage;
    gridGC=gridImage.getGraphics();
  }

 
  /**
   * Charge toutes les images necessaires a la construction de la scene
   */
  private void loadAllImages() {
    
    for (int i = 0; i < 2 ; i++) {
      
      pacGrid[i]=Toolkit.getDefaultToolkit().getImage("images/Grid"+i+".gif");
      tracker.addImage(pacGrid[i],1);
    }
    pacGrid[2]=Toolkit.getDefaultToolkit().getImage("images/patgum.gif");
    tracker.addImage(pacGrid[2],1);
    pacGrid[3]=Toolkit.getDefaultToolkit().getImage("images/superpat.gif");
    tracker.addImage(pacGrid[3],1);
     pacGrid[4]=Toolkit.getDefaultToolkit().getImage("images/Grid3.gif");
    tracker.addImage(pacGrid[4],1);
    for (int i=0; i < 4;i++) {
      acteurs[i][0]=Toolkit.getDefaultToolkit().getImage("images/ghost"+i+"1.gif");
      tracker.addImage(acteurs[i][0],2);
      acteurs[i][1]=Toolkit.getDefaultToolkit().getImage("images/ghost"+i+"2.gif");
      tracker.addImage(acteurs[i][1],2);
      acteurs[i][2]=Toolkit.getDefaultToolkit().getImage("images/ghostS.gif");
      tracker.addImage(acteurs[i][2],2);
    }

    
    for (int i = 0; i < 8 ; i++) {
      acteurs[4][i]=Toolkit.getDefaultToolkit().getImage("images/pacman"+i+".gif");
       tracker.addImage(acteurs[4][i],3);
    }

     try 
      {
	while(tracker.statusAll(false) != MediaTracker.COMPLETE) {
	 
	  tracker.waitForAll();}
      }
    catch (InterruptedException e) {
      System.out.println("Erreur lors du chargement des images");
      return;
    }
  }


  /** Construit l'image representant la grille 
   */
  private void setGridImage(PacGrid pacgrid)
  {
    int val;

    gridGC = gridImage.getGraphics();

    size = pacgrid.getSquareSize();
    nb_columns = pacgrid.getNbColumns();
    nb_lines= pacgrid.getNbLines();
    widthGrid=nb_columns*size;
    heightGrid=nb_lines*size;

    
    for (int column = 0 ; column < nb_columns ; column++)
      { 
	for (int line = 0 ; line < nb_lines ; line++)
	  {
	
	    val = pacgrid.getGridValue(column,line);
	
	    gridGC.drawImage(pacGrid[val], column * size , line * size,size,size,null);
	
	    val = pacgrid.getPatValue(column,line);
	    	    
	    if (val != 0) {
	      gridGC.drawImage(pacGrid[val],column*size ,line*size,size,size,null);
	    }
	  }
      }

  }

   

  public void update (Observable o,Object arg) {
    	// Mise a jour de l'image de la grille
	
	     PacGrid pacgrid=(PacGrid)o;
	     Position p=(Position)arg;
	     if (p.x == -1)
	       // On reconstruit toute l'image representant la grille
	       setGridImage(pacgrid);
	     else
	       // On met a jour simplement une case de la grille
    gridGC.drawImage(pacGrid[pacgrid.getGridValue(p.x,p.y)],p.x * size,p.y * size,size,size,null);
  }


  /**
   * Methode utilisee par le projecteur
   * Affiche selon les cas un message ou la scene 
   */
   
  public void constructScene(Graphics gc) {
    if (game.message) {
      switch (game.msgID) {
      case 0: displayLoose(gc);break;//Ecran perte d'une vie 
      case 1 : displayStartScreen(gc);break;//Ecran de depart
      case 2: displayLevelEnd(gc);break;//Ecran de fin de level
      case 3:displayGameOver(gc);break;//Ecran de fin de partie
      case 4: displayHiScores(gc);break;//Ecran des hiscores
      default : gc.setColor(Color.black);gc.fillRect(0,0,420,340);break;
      }
    }
    else 
      // Construit l'image du jeu
      displayScene(gc);
  }
  
  

  // Affiche les vies  
  private void displayLifes(Graphics gc) {
    int ind = (int)Math.rint(Math.random());
    gc.setFont(defaultFont);

    gc.setColor(Color.white);
    gc.drawString("LIFE(S)",430,100);
    for (int i=0; i < game.nb_lifes;i++)
	  gc.drawImage(acteurs[4][ind],425+(20 * i),120,size,size,null);
  }

  // Affiche le score
  private void displayScore(Graphics gc) {
    gc.setFont(defaultFont);

    gc.setColor(Color.white);
    gc.drawString("SCORE",430,50);
    
    gc.drawString(game.score.getScoreValue(),430,70);
  }

  // Affiche la scene
  private void displayScene(Graphics gc)
  {

    Position position;
    Acteur acteur;
    // affichage du score
    displayScore(gc);
    // affichage des vies
    displayLifes(gc);
    // affichage de la grille
    gc.drawImage(gridImage,0,0,widthGrid,heightGrid,null);
    
    // affichage des differents acteurs
    
    Enumeration liste=game.acteurs.elements();
    while (liste.hasMoreElements()) 
      {
	
	acteur=(Acteur)liste.nextElement();
	position= acteur.getPosition();
	// affiche l'image adequate representant l'acteur au moment present
	gc.drawImage(acteurs[acteur.getID()][acteur.getIndex()],position.x,position.y,size,size,null);
	
	  }
  }
  
  
  
  // Ecran des hi-scores
  private void displayHiScores(Graphics gc) {
        
    gc.setColor(Color.white);
    gc.setFont(new Font("Serif",Font.BOLD,20));

    gc.drawString("PACMAN HI SCORES",120,50);
    gc.drawImage(acteurs[4][0],90,30,20,20,null);
   
    gc.setFont(new Font("Serif",Font.PLAIN ,18));

    for (int i=0; i < 10; i++) 
      {
	//if  (hiscore != null) {	 
	gc.drawString(game.score.getHiScoreName(i),80,100+(i*20));
	gc.drawString(game.score.getHiScoreVal(i),300,100+(i*20));
	}

  }
    
    
   

  // Ecran de depart
  public void displayStartScreen(Graphics gc) {

    gc.setColor(Color.white);
    gc.setFont(new Font("Serif",Font.BOLD,20));
    
    gc.drawString("PACMAN",200,50);

    gc.drawImage(acteurs[0][(int)Math.rint(Math.random())],110,80,20,20,null);
    gc.drawImage(acteurs[1][(int)Math.rint(Math.random())],170,80,20,20,null);
    gc.drawImage(acteurs[2][(int)Math.rint(Math.random())],140,80,20,20,null);
    gc.drawImage(acteurs[3][(int)Math.rint(Math.random())],210,80,20,20,null);
    gc.drawImage(acteurs[4][(int)Math.rint(Math.random())],250,80,20,20,null); 
    gc.setFont(new Font("Serif",Font.PLAIN ,18));
    gc.drawString("Use menu to start game",200,180);
    gc.drawImage(acteurs[4][(int)Math.rint(Math.random())],170,160,20,20,null); 
    gc.drawImage(acteurs[4][(int)Math.rint(Math.random())],170,230,20,20,null); 
    gc.drawString("Use Arrow Keys to play",200,240);
  
  }

  // Ecran perte d'une vie
  public void displayLoose(Graphics gc) {

    displayScore(gc);
    displayLifes(gc);
    gc.drawImage(gridImage,0,0,widthGrid,heightGrid,null);
  }
  
  // Ecran fin de niveau
  public void displayLevelEnd(Graphics gc) {
    
    gc.setColor(Color.white);
    gc.setFont(new Font("Serif",Font.BOLD,20));
    gc.drawString("LEVEL FINISHED",50,100);
    gc.setFont(new Font("Serif",Font.BOLD,16));
    gc.drawString("Well done ...",70,150);
    gc.drawImage(acteurs[4][0],80,200,20,20,null);
  }
 
  // Ecran fin d'une partie
 public void displayGameOver(Graphics gc) {

   gc.setFont(new Font("Serif",Font.BOLD,20));
   gc.setColor(Color.white);
   gc.drawString("GAME OVER",150,100);
   gc.drawImage(acteurs[4][1],125,85,20,20,null);
   gc.drawImage(acteurs[4][3],280,85,20,20,null);
   gc.drawImage(acteurs[4][2],125,185,20,20,null);
   gc.setFont(new Font("Serif",Font.BOLD,16));
   gc.drawString("Use menu to restart",150,200);
  }


}



















