import java.util.*;

/** Acteur class. Classe abstraite definissant les attributs
 * et les methodes communes a chaque acteur, les acteurs sont observe
 * par la class Regle gerant les interactions entre acteurs
 */

abstract class Acteur extends Observable {

  // Le groupe des threads acteur 
  static ThreadGroup tg;

  // Position de l'acteur
  protected Position position ; 
  
  // Position de depart de l'acteur
  protected Position position_origine;
  
  // identificateur de l'acteur
  private int ID;

  // l'acteur est il mangeable

  private boolean eatable;


  public Acteur(Position position)
  {
    this(position,true,0);
  }
  
  public Acteur(Position start,boolean eatable) 
  {
    this(start,eatable,0);
  }
  
  public Acteur(Position start,boolean eatable,int ID) 
  {
    position_origine=start;
    position=new Position(start.x,start.y);
    this.eatable=eatable;
    this.ID=ID;
  }
   
  
  // retourne un entier representant l'etat de l'acteur 
  abstract int getIndex();

  // methodes effectuant les actions necessaires lorsque l'acteur
  // est mange
  abstract void kill();

  // operation sur le thread
  abstract void start();
 
  abstract void suspend();

  abstract void resume();

  abstract void terminate();
  

  /** retourne un nom identifiant l'acteur (equivalent a toString())
   */
  abstract String getName();
  



 
  /** Remet l'acteur a sa position de depart
   */
  public void setStartPosition() 
  {
    position.x=position_origine.x;
    position.y=position_origine.y;
    
  }

  /** Retourne un entier decrivant l'etat de l'acteur
   */
  public int getID() 
  {
    return ID;
  }
  /** Accesseur a l'attribut position
   */
  public Position getPosition()
  {
    return position;
  }
  

  // Reprend le fil d'execution de tout les threads du groupe
  static public void resumeAll() {
    tg.resume();
  }
 
  // Suspend l'execution de tout les threads du groupe
  static public void suspendAll() {
      tg.suspend();
  }
  
  // Stoppe l'execution de tout les threads du groupe
  static public void stopAll() {
    tg.stop();
  }
  
  public boolean isEatable() {
    return eatable;
  }

  public void setEatable(boolean b){
    eatable= b;
  }
  
  public void setPosition(Position position)
  {
    this.position=position;
  }
  
    
}




