import java.util.Vector;

/**
   Cette classe stocke les clients qui se connectent sur le serveur.
   Elle gre galement les dconnexions. Les deux premiers clients  se 
   connecter sont les deux joueurs (clients joueurs), les clients suivants peuvent suivre 
   la partie mais ne peuvent pas jouer (ils sont galement stocks dans le vecteur - clients non joueurs).
   Le premier client "non joueur" du vecteur peut entrer dans la partie en cours 
   lorsque l'un des deux clients joueur se dconnecte.<br><br>
   
   A chaque joueur est attribu un numro (identifiant) pour dterminer son rang dans la file d'attente des non joueurs. 
*/
public class StockClient{
   Vector v=new Vector();
   ClientDistant cd;

   /**
      Enregistrement d'un client
      @param ad le client cherchant  se connecter au serveur
   */     
   public void enregistre(ClientDistant cd){
      this.cd=cd;
      
      //ajout du nouveau client dans le vecteur
      v.addElement(cd);
      
      try{
        switch(v.size()){
        case 1: //Premier joueur  se ceonnecter --> joueur 1
          cd.setJoueur(1);
          break;
        case 2://deuxieme joueur  se connecter --> joueur 2
         //si entre temps le joueur 1 s'est dconnect, il reste le joueur 2 dans le vecteur
         //on attribue donc le numro 1 au nouveau client puisque le 2 est dj enregistr
          if(((ClientDistant)v.elementAt(0)).getJoueur()!=2)
             cd.setJoueur(2);
          else
             cd.setJoueur(1);
          break;
        default:  // partir du troisime joueur on enlve 
                  //la possibilit de jouer 
          cd.setJoueur(v.size());
          cd.setListener(false);
        }//fin switch
      }catch(Exception ex){
        System.out.println("Exception declenchee par enregistre de StockClient");
        ex.printStackTrace();
      }//fin catch
   }//fin enregistre
   

   /**
      Enleve un client du vecteur lorsque celui-ci se dconnecte
      @param numJoueur l'identifiant du joueur  supprimer
   */   
   public void remove(int numJoueur){
      try{
         int rang=-1; 
         
         for (int i=0; i<v.size();i++){
            if(numJoueur==((ClientDistant)v.elementAt(i)).getJoueur()){
               v.removeElementAt(i);
               break;
            }//fin if            
         }//fin for  
         
         //si le client joueur 'numJoueur' se dconnecte, le non joueur qui prend 
         //sa place prendra comme identifiant le rang 'rang'
         if(numJoueur==1) rang=0;
         if(numJoueur==2) rang=1;
         if ((rang!=-1) && (v.size()!=0))
           remplacerJoueur(rang,numJoueur);
      }catch(Exception ex){
        System.out.println("Exception declenchee par enregistre de StockClient");
        ex.printStackTrace();
      }//fin catch
   }//fin remove
   

   /**
      Remplace un client joueur qui se dconnecte par un client non joueur si 
      il en existe un dans le vecteur
      @param rang le rang que va prendre le nouveau joueur
      @param numJoueur le numro de joueur qui lui est attribu
   */
   private void remplacerJoueur(int rang, int numJoueur){
      try{
         //si il existe un client non joueur capable de prendre la suite
         if(v.size()>1){
            ((ClientDistant)v.elementAt(0)).messageAlerte("Votre adversaire s'est dconnect...il a t remplac .");
            ((ClientDistant)v.elementAt(1)).setJoueur(numJoueur);
            ClientDistant ad=(ClientDistant)v.elementAt(1);
            cd.setListener(true);
            v.removeElementAt(1);
            v.insertElementAt(ad,rang);
            cd.refreshClient();
         }
         else  //aucun client non joueur ne s'est enregistr, il n'y a plus qu'un seul joueur dans le vecteur
            ((ClientDistant)v.elementAt(0)).messageAlerte("Votre adversaire s'est dconnect...pas d'autre joueur en attente.");         
      }catch(Exception ex){
        System.out.println("Exception declenchee par enregistre de StockClient");
        ex.printStackTrace();
      }//fin catch
   }//fin remplacerJoueur   
   
   
   /**
      Lance le rafraichissement de tous les clients contenus dans le vecteur. 
      Gre galement le dblocage et le blocage des vnements chez le client qui vient de jouer
      pour l'empcher de jouer le coup de son adversaire.
      Vrifie galement si la partie est termine pour alerter tous les clients.
      @param tab la nouvelle matrice  afficher chez les clients
      @param p l'objet Puissance associ aux clients
   */   
   public void change(int[][] tab,Puissance p){
      //parcourt tous les client et lance un repaint  distance
      for (int i=0; i<v.size();i++){
         cd=(ClientDistant)(v.elementAt(i));
         try{
            if(cd.getJoueur()==p.getJoueurActif()) cd.setEventOn();
            else cd.setEventOff();
            cd.refreshClient(tab);
         }catch(Exception ex){
            System.out.println("Exception declenchee par change de StockClient ");
            ex.printStackTrace();      
         }//fin catch
      }//fin for
      
      if(p.partieTerminee()){
         String message="";
         if(p.getVainqueur()==0){ 
            message="Match nul...";
         }
         else{ 
            String alignement=p.getAlignement();
            if(p.getVainqueur()==1) {
               message="Le joueur jaune a gagn..." + alignement;
            }
            else{
               message="Le joueur bleu a gagn..." + alignement;
            }
         }
         for (int i=0; i<v.size();i++){
            cd=(ClientDistant)(v.elementAt(i));
            try{
               cd.messageAlerte(message);
            }catch(Exception ex){}
         }//fin for           
      }//fin if partieTerminee
   } // change
  
  
  
   /**
      Affiche le vecteur chez le serveur.
   */  
  private void afficherVecteur(){
      try{
          for(int i=0; i<v.size();i++)
              System.out.print(((ClientDistant)v.elementAt(i)).getJoueur() +"\t");
          System.out.print("\n");      
      }catch(Exception ex){System.out.println("Exception declenchee par afficherVecteur de StockClient");}
  }

}//fin class StockClient


