import java.rmi.*;
import java.rmi.server.*;

/**
  *Classe Puissance
  * Cette classe implmente tous les calculs et les traitements d'un jeu de puissance 4;
  */
public class Puissance extends UnicastRemoteObject implements PuissanceDistant{
  private int[][] tableau; //0=rien;1=joueur 1;2=joueur 2
  private int joueurActif; //1 ou 2
  private int joueColonne; //colonne de 1  7
  private int vainqueur=0; //1 ou 2
  private int x,y;         //position(x,y) du dernier jeton jou

   private StockClient stc; //stockage des clients dans un Vecteur

  //---------------------------
  //Constructeur et Primitives
  //---------------------------
 
  /**
    *Constructeur: construit le tableau logique.
    *joueurPlay(1 ou2) est le joueur qui commence 
    */   
  public Puissance(int joueurPlay) throws RemoteException{
   
   try{  
       stc=new StockClient();
       tableau = new int[7+1][6+1];
       joueurActif = joueurPlay;  
       resetStart(); 
   }catch(Exception ex){
   System.out.println("Exception declenchee par le constructeur de Puissance");
   ex.printStackTrace();}
      
  }//public Puissance() 


  /**
    *Mettre le tableau du jeu  zro
    */
  public void reset(){
   for(int j=0;j<6+1;j++){
       for(int i=0;i<7+1;i++){
          tableau[i][j] = 0;           
     }//for(int i=0;i<7;i++)
  }//for(int j=0;j<6;j++)  
   vainqueur=0;
   joueColonne=0;
   x=0;
   y=0;
   changeClient();
  }//public void reset()  


   public void resetStart(){
     for(int j=0;j<6+1;j++){
       for(int i=0;i<7+1;i++){
          tableau[i][j] = 0;           
     }//for(int i=0;i<7;i++)
    }//for(int j=0;j<6;j++)  
    vainqueur=0;
  }//public void reset()  

  /**
     *Retourne la matrice
     */
  public int[][] getTableau(){
      return tableau;
  }//public int getTableau()
  
  /**
     *Retourne le numro du joueur qui va jouer (1 ou 2)
     */
  public int getJoueurActif(){
      return joueurActif;
  }//public int getJoueurActif()


  /**
     *Modifie le joueur qui va jouer.Si le joueur 1 a jou, 
     *alors c'est au tour du joueur 2. Et vis versa.
     */
  public void changeJoueurActif(){
      if(joueurActif==1)
    joueurActif=2;
      else 
    joueurActif=1;    
  }//public int getJoueurActif()



  /**
    *Retourne le joueur vainqueur de la partie (1 ou 2)  
    */
  public int getVainqueur(){
    return vainqueur;      
  }//public int getVainqueur() 


  /**
    *Affecte le vainqueur de la partie (1 ou 2) 
    */
  public void setVainqueur(int gagnant){
    vainqueur = gagnant;   
  }//public void setVainqueur(int gagnant)


  /**
    *Retourne la colonne qui vient tre joue (de 1  7).
    */ 
  public int getJoueColonne(){
    return joueColonne; 
 }//public int getJoueColonne()

 /**
   *Affecte la colonne jouee (de 1  7)
   */
 public void setJoueColonne(int colonne){
   joueColonne = colonne;
 }//public void setJoueColonne(int colonne)

/**Vrifie si une colonne est pleine. Renvoie vrai si elle l'est, faux sinon*/
   public boolean colonnePleine(int col){
      return tableau[col][0]==1;
   }//fin colonnePleine


/** Retourne le type d'alignement gagant quand un joureur gagne une partie : horizontal, vertical ou diagonal*/
   public String getAlignement(){
      String alignement=new String();
      int nbJetonsHorizontal     = nbJetonsAlignesEst() + nbJetonsAlignesOuest() +1;
      int nbJetonsVertical       = nbJetonsAlignesSud() + 1;
      int nbJetonsDiagonal1Bisec = nbJetonsAlignesNordEst() + nbJetonsAlignesSudOuest() + 1;
      int nbJetonsDiagonal2Bisec = nbJetonsAlignesNordOuest() + nbJetonsAlignesSudEst() + 1;
       
      if (nbJetonsHorizontal==4) alignement=new String("Alignement horizontal");
      if (nbJetonsVertical==4) alignement=new String("Alignement vertical");               
      if (nbJetonsDiagonal1Bisec==4 || nbJetonsDiagonal2Bisec==4) alignement=new String("Alignement diagonal");   
      return alignement;
   }
  //----------------------- 
  //Mthodes Complexes
  //-----------------------

  /**
    *afficheTableau : affiche le tableau du jeu en mode texte
    */    
  public void afficheTableau(){
    
    for(int j=1;j<6+1;j++){
       for(int i=1;i<7+1;i++){
          if(tableau[i][j]==0)
        System.out.print("[" + " " + "]");
     else 
        System.out.print("[" + tableau[i][j] + "]");              
       }//for(int i=0;i<7;i++)
       System.out.println();   
    }//for(int j=0;j<6;j++)   
  }//  public void afficheTableau()  


   public void afficheTableau2(){
    
    for(int j=0;j<6+1;j++){
       for(int i=0;i<7+1;i++){
          if(tableau[i][j]==0)
        System.out.print("[" + " " + "]");
     else 
        System.out.print("[" + tableau[i][j] + "]");              
       }//for(int i=0;i<7;i++)
       System.out.println();   
    }//for(int j=0;j<6;j++)   
  }//  public void afficheTableau2()  
  
  
  
  /**
    *Retourne vrai si le jeton est jou, faux sinon.
    *Le joueur de numro joueur, joue la colonne de numro colonne.
    *La mthode <CODE>jouerLaColonne</CODE> dtermine la position exacte
    *dans le tableau du jeu de ce jeton qui est jou par le joueur joueur.
    *Cela revient  dterminer en particulier la ligne du jeton.
    *On complete le tableau en partant de l'indice le plus haut.
    *C'est--dire que lorsque un jeton est jou dans la colonne c,
    *le jeton va se placer sur la ligne 5. si la ligne 6 est dj occupe
    *alors il ira se placer sur la ligne 4,....       
    *joueur = 1 ou 2
    *colonne = de 1  7
    */
  public boolean jouerLaColonne(int joueur,int colonne){ 
    if((joueurActif==joueur) && (colonne>=1 && colonne<=7)){//C'est le bon joueur qui joue
       int indiceLigne=tableau[colonne][0];
       
       if(indiceLigne==1) return false;
       else if(indiceLigne==0){
          tableau[colonne][0] = 6;
          tableau[colonne][6] = joueur;
          x=colonne; y=6;
    // System.out.println("Jeton(" + colonne +",6)");
          changeClient(); 
          //afficheTableau(); 
          return true;
       }
       else {
          tableau[colonne][0] = indiceLigne-1;
          tableau[colonne][indiceLigne-1] = joueur;
          x=colonne; y=indiceLigne-1; 
          //System.out.println("Jeton("+ colonne + "," + (indiceLigne-1) + ")"); 
          changeClient();
          //afficheTableau();
          return true;
       }
       
    }//if(joueurActif==joueur)     
    else { 
      //System.out.println("Mauvais joueur : l autre joueur !!");
      return false;  
    }
  }//public void jouerLaColonne(int joueur,int colonne)



  /**
    *Retourne le plus nombre de jetons aligns  partir de la position(x,y)
    */
  public int verifierAlignement(){
    int res;
    int nbJetonsHorizontal=0;  //nombre de jetons aligns horizontalement
    int nbJetonsVertical=0;    //nombre de jetons aligns verticalemnt
    int nbJetonsDiagonal1Bisec;//nombre de jetons aligns diagonalement sur la 1ere. bisectrice
    int nbJetonsDiagonal2Bisec;//nombre de jetons aligns diagonalement sur la 2eme. bisectrice
 
    //Calcul des alignements globaux
    nbJetonsHorizontal     = nbJetonsAlignesEst() + nbJetonsAlignesOuest() +1;
    nbJetonsVertical       = nbJetonsAlignesSud() + 1;
    nbJetonsDiagonal1Bisec = nbJetonsAlignesNordEst() + nbJetonsAlignesSudOuest() + 1;
    nbJetonsDiagonal2Bisec = nbJetonsAlignesNordOuest() + nbJetonsAlignesSudEst() + 1;
    
    res = Math.max(nbJetonsHorizontal,nbJetonsVertical);
    res = Math.max(res,nbJetonsDiagonal1Bisec);
    res = Math.max(res,nbJetonsDiagonal2Bisec);      
    
    return res;      
    
  }//public verifierAlignement() 





  /**
    *Retourne le nombre de jeton d'un meme joueur alignes vers Est
    */
  public int nbJetonsAlignesEst(){
      int pos_x = this.x + 1;  //curseur de parcours vers l'est
      int nbJetonsTrouves =0;  //nombre de jetons rencontrs sur le parcours
      
      while((pos_x<8) && (tableau[pos_x][y]==getJoueurActif())){
         pos_x++; //se deplace vers l'Est
         nbJetonsTrouves++;
      }//while(...) 
      return nbJetonsTrouves;
  }//public int nbJetonsAlignesEst()



 /**
    *Retourne le nombre de jeton d'un meme joueur alignes vers Ouest
    */
  public int nbJetonsAlignesOuest(){
      int pos_x = this.x - 1;  //curseur de parcours vers l'ouest
      int nbJetonsTrouves =0;  //nombre de jetons rencontrs sur le parcours
      
      while((pos_x>0) && (tableau[pos_x][y]==getJoueurActif())){
         pos_x--; //se deplace vers l'Ouest
         nbJetonsTrouves++;
      }//while(...) 
      return nbJetonsTrouves;
  }//public int nbJetonsAlignesOuest()



/**
    *Retourne le nombre de jeton d'un meme joueur alignes vers Sud
    */
  public int nbJetonsAlignesSud(){
      int pos_y = this.y + 1;  //curseur de parcours vers le sud
      int nbJetonsTrouves =0;  //nombre de jetons rencontrs sur le parcours
      
      while((pos_y<7) && (tableau[x][pos_y]==getJoueurActif())){
         pos_y++; //se deplace vers le sud
         nbJetonsTrouves++;
      }//while(...) 
      return nbJetonsTrouves;
  }//public int nbJetonsAlignesSud()


/**
    *Retourne le nombre de jeton d'un meme joueur alignes vers Nord-Est
    */
  public int nbJetonsAlignesNordEst(){
      int pos_x = this.x + 1;  //position x de parcours vers l'est
      int pos_y = this.y - 1;  //position y de parcours vers le nord
      int nbJetonsTrouves =0;  //nombre de jetons rencontrs sur le parcours
      
      while(((pos_x<8) && (pos_y>0)) && (tableau[pos_x][pos_y]==getJoueurActif())){
         pos_x++; //se deplace vers l'Est
         pos_y--; //se deplace vers le nord
         nbJetonsTrouves++;
      }//while(...) 
      return nbJetonsTrouves;
  }//public int nbJetonsAlignesNordEst()


/**
    *Retourne le nombre de jeton d'un meme joueur alignes vers Sud-Ouest
    */
  public int nbJetonsAlignesSudOuest(){
      int pos_x = this.x - 1;  //position x de parcours vers l'ouest
      int pos_y = this.y + 1;  //position y de parcours vers le sud
      int nbJetonsTrouves =0;  //nombre de jetons rencontrs sur le parcours
      
      while(((pos_x>0) && (pos_y<7)) && (tableau[pos_x][pos_y]==getJoueurActif())){
         pos_x--; //se deplace vers l'Ouest
         pos_y++; //se deplace vers le sud
         nbJetonsTrouves++;
      }//while(...) 
      return nbJetonsTrouves;
  }//public int nbJetonsAlignesSudOuest()




/**
    *Retourne le nombre de jeton d'un meme joueur alignes vers Nord-Ouest
    */
  public int nbJetonsAlignesNordOuest(){
      int pos_x = this.x - 1;  //position x de parcours vers l'ouest
      int pos_y = this.y - 1;  //position y de parcours vers le nord
      int nbJetonsTrouves =0;  //nombre de jetons rencontrs sur le parcours
      
      while(((pos_x>0) && (pos_y>0)) && (tableau[pos_x][pos_y]==getJoueurActif())){
         pos_x--; //se deplace vers l'Ouest
         pos_y--; //se deplace vers le nord
         nbJetonsTrouves++;
      }//while(...) 
      return nbJetonsTrouves;
  }//public int nbJetonsAlignesNordOuest()




/**
    *Retourne le nombre de jeton d'un meme joueur alignes vers Sud-Est
    */
  public int nbJetonsAlignesSudEst(){
      int pos_x = this.x + 1;  //position x de parcours vers l'est
      int pos_y = this.y + 1;  //position y de parcours vers le sud
      int nbJetonsTrouves =0;  //nombre de jetons rencontrs sur le parcours
      
      while(((pos_x<8) && (pos_y<7)) && (tableau[pos_x][pos_y]==getJoueurActif())){
         pos_x++; //se deplace vers l'est
         pos_y++; //se deplace vers le sud
         nbJetonsTrouves++;
      }//while(...) 
      return nbJetonsTrouves;
  }//public int nbJetonsAlignesSudEst()


/**
  *Retourne vrai si le jeu partie est termine car la grille est sature,
  *faux sinon.
  */
  public boolean grilleSaturee(){
    int indColonne;  //indice de la colonne
    int res=1;       //pour determiner la grille est sature 
    //lorsque la colonne indColonne est sature, tableau[indColonne][0] = 1
    for(indColonne=1;indColonne<8;indColonne++)
       res=res*tableau[indColonne][0]; 
    if(res==1) return true;
    else return false; 
  }//public boolean grilleSaturee()


/**
  *Retourne vrai si la partie est termine, faux sinon.
  *La partie est termine si l'un des joueurs a gagn ou si la grille est sature.
  */
  public boolean partieTerminee(){

     if( verifierAlignement()>=4){
        vainqueur = getJoueurActif();
        return true;
     }//if( verifierAlignement()>=4)   

     return grilleSaturee(); 
  }//public boolean partieTerminee()



/**********************************************************/
/*     Implementation de l'interface  PuissanceDistant    */
/**********************************************************/
   /**
      Enregistre les clients distants dans le vecteur de la classe StockClient.
      @param ad <br><DD>l'interface graphique distante cliente  enregistrer
   */
   public void enregistreClient(ClientDistant cd){
      
       try{
           //ad=(AireDistant)Naming.lookup("AireDeJeu");
         stc.enregistre(cd);
      }catch(Exception ex){ System.out.println("Exception declenchee par enregistreClient de Puissance");
                            ex.printStackTrace();}
          
   }//fin enregistreClient
   
   /**
      Elimine les clients distants dans le vecteur de la classe StockClient.
      @param numJoueur <br><DD>l'identifiant de l'interface graphique distante cliente  enlever
   */   
   public void removeClient(int numJoueur){
      try{
         stc.remove(numJoueur);
      }catch(Exception ex){ System.out.println("Exception declenchee par enregistreClient de Puissance");
                            ex.printStackTrace();}
          
   }//fin enregistreClient
   
   /**
      Lance la mise  jour des clients distants dans le vecteur de la classe StockClient en fonction de la nouvelle matrice calcule.
      @param tableau <br><DD>la nouvelle matrice que les clients doivent afficher
      @param this <br><dd>l'objet se trouvant sur le serveur
   */   
   public void changeClient(){
      stc.change(tableau,this);
   }//fin changeClient


}//public class Puissance





