
import java.awt.*;
import java.awt.event.*;
/**

     Fichier : Help.java
     Classe : Help<BR>
   Objet : cree la fenetre du manuel d'utilisation sous forme d'une boite de dialogue contenant du texte
<BR>   Version : 1.0
 <BR>  Date : 31 Mars 1998
*/
public class Help extends Dialog implements ActionListener{

/*----------------------------------
    Donnees membres
-----------------------------------*/
   //private MenuAppli parent;   // fenetre parente
    private Frame  parent;
    private Client clt;
    Button quitter=new Button("Quitter");
    Button fontionnement = new Button("Fonctionnement");
    Button regleDuJeu = new Button("Regle du Jeu");
    TextArea texte=new TextArea(2,2);     //zone d'affichage du texte
    int lgueur = 440; //550
    int larg = 440;   //600
    int POSX=(Toolkit.getDefaultToolkit().getScreenSize().width/2)-(lgueur/2);
    int POSY=(Toolkit.getDefaultToolkit().getScreenSize().height/2)-(larg/2);

    // Fontes
    Font fTitre1  = new Font("Helvetica", Font.BOLD, 20);
    Font fTitre2  = new Font("Helvetica", Font.BOLD, 15);
    Font fNormal = new Font("Helvetica", Font.PLAIN,15);
/*---------------------------
    Constructeur
------------------------------*/

  /** Construit la fenetre d'aide <BR>parent : la fenetre appelante*/
   public Help(Frame parent, Client c){
      super(parent,"Help");
      this.clt = c;
      this.parent=parent;     
      quitter.addActionListener(this);
      regleDuJeu.addActionListener(this);
      fontionnement.addActionListener(this);
      texte.setBackground(Color.white);
      texte.setEditable(false);
      creerTexteIntro();
      add(texte);
       
      Panel p= new Panel();

      p.add(fontionnement);
      p.add(regleDuJeu);     
      p.add(quitter);
      add(p,"North");
      setBackground(Color.lightGray);
      setSize(lgueur,larg);
      setLocation(POSX,POSY);    
      setResizable(true);
   }

   /** 
	RESULTAT : gre les vnements sur la boite de dialogue */
   public void actionPerformed(ActionEvent evt){
      Object source = evt.getSource();
      if(source==quitter) {
          clt.setEnableHelp(true);
          dispose();
      }
      if(source==fontionnement) creerTexteFonctionnement();
      if(source==regleDuJeu) creerTexteRegleDuJeu();
   }//fin ActionPerformed



/**
	RESULTAT : cre et affiche le texte d'introduction de l'aide en ligne*/
   private void creerTexteIntro(){
      texte.setFont(fTitre2);
      texte.setText("\n\n\n                        Puissance 4\n\n"+
      "Puissance 4 est un jeu en reseau ecrit en Java v1.1 utilisant le R.M.I. \n" +
      "Dat e    : 31 Mars 1999\n" +
      "Promotion: IUP MIAGE 3 - 1999\n"+ 
      "Auteurs  : Gleizes Christelle & Truong Hon-Po \n");

   }//fin creerTexteIntro

/** 
   RESULTAT : cre et affiche le texte de description des regles du jeu */
   private void creerTexteRegleDuJeu(){
      texte.setFont(fNormal);      
      texte.setText("\n\n\n Regles du Jeu\n\n\n"+
      "Puissance 4 est un jeu en reseau qui se joue a deux. \n"+
      "Il est compose d une grille de 7 colonnes sur 6 lignes.\n"+
      "Cette grille est formee de 42 (7x6) emplacements (trous) pour placer des jetons.\n"+
      "Un joueur possede des jetons de couleur bleu et, l autre des jetons de couleur jaune.\n"+
      "A tour de role, les concurrents jouent un jeton dans une colonne de la grille\n"+
      "(en le laissant tomber dans la colonne (1 a 7)\n"+
      "Le vainqueur est celui qui aura reussi a aligner le premier quatre jetons :\n"+
      "     horizontalement,\n"+
      "     verticalement,\n"+
      "     ou diagonalement\n"+
      "\n");           

      
   }//fin creerTexteDef


    /** affiche le texte decrivant le fonctionnement du jeu*/
   private void creerTexteFonctionnement(){ 
      texte.setFont(fNormal);
      texte.setText("\n\n FONCTIONNEMENT GENERAL\n\n\n"+
      "Ce logiciel permet a deux personnes de jouer au jeu Puissance 4 en reseau\n"+
      "\n"+
      "Les deux premieres personnes qui demandent (se connectent) de jouer, deviennent les deux joueurs.\n"+
      "Toutes les autres personnes qui se connectent apres ne peuvent qu observer le jeu.\n"+
      "Lorsque l un des deux joueurs quitte la partie, le premier spectateur \n"+ 
      "(la troisieme personne qui se connecte) remplace automatiquement le joueur demissionnaire.\n"+
      "\n"+
      "Le premier concurrent qui joue est celui qui s est connecte le premier, il joue avec des jetons bleus.\n"+
      "L autre joueur joue avec des jetons de couleur jaune.\n"+
       "\n"+
      "POUR JOUER :\n"+
      "Il suffit de choisir la colonne (1 a 7) dans laquelle on laisse tomber son jeton :\n"+
      "   - en double cliquant dans la colonne desiree.\n"+
      "   - en tapant le numero de la colonne dans le champ de saisi \"Numero de Colonne\"\n"+
      "      et en cliquant sur le bouton \"OK\"\n"+
      "\n"+
             

      
     "POUR FAIRE UNE NOUVELLE PARTIE :\n"+
     "Les deux joueurs peuvent a tout moment faire une autre partie en cliquant sur le bouton\n"+
     "\"Nouvelle Partie\". \n"+
     "\n"+
     
     "POUR OBTENIR L AIDE EN LIGNE :\n"+
     "A tout moment, les joueurs peuvent demander de l aide en cliquant sur le bouton \"Help\".\n"+
     "\n"+
      
     "POUR QUITTER :\n"+
     "Il suffit d appuyer sur le bouton \"Quitter\" de la fenetre du jeu.\n"+
                  
      "\n"); 
   }//fin creerTexteFontonnement

    


 
}//fin class Help
