import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import java.rmi.server.*;

/** 
   Programme de lancement du client.
   Cette classe gre la communication et les vnements entre Puissance
   et AireDeJeu
*/
public class Client extends UnicastRemoteObject implements ClientDistant, ActionListener, MouseListener, WindowListener{
    
    private PuissanceDistant p; //Interface permettant l'accs  l'objet distant du serveur
    private AireDeJeu gg; //Aire de jeu cliente associe  l'objet distant
    private Frame f; //fentre d'affichage 
    static private String hostServeur ="";
    Help fH; //fenetre dialogue Help

   /** Constructeur */    
    public Client()throws RemoteException{
   
        try{
           //Initialisation RMI
            System.setSecurityManager(new RMISecurityManager());
           
            System.out.println("Faire lookup sur : " + hostServeur);
            p=(PuissanceDistant)Naming.lookup(hostServeur);
                       
           //dfinition de l'aire de jeu           
            gg=new AireDeJeu(this,this,p.getTableau());
       
           //enregistrement du client                   
            p.enregistreClient(this);
           
           //initialisation des vnements qui vont tre grs
           if(gg.getJoueur()!=p.getJoueurActif()) gg.setEventOff();
           
           //Initialisation et affichage de la fentre
           f=gg.getFrame();
           f.addWindowListener(this);
           f.setVisible(true);           
        } catch(Exception ex){ 
        System.out.println("Exception declenchee par le constructeur de Client ");
        ex.printStackTrace();}
    }//fin constructeur 
    
    public static void main(String[] args){
        
        if(args.length==0){
            System.out.println("Serveur est en local : ");
            hostServeur = "puissance4";
        }//if(lenght()
        else if(args.length==1){
            System.out.println("Host du Serveur : " + args[0]);
            hostServeur = "rmi://" + args[0] + "/puissance4";
        }//if(lenght()
        else {
            System.out.println("Syntaxe : java Client host_du_serveur");
            System.out.println("      ex: host_du_serveur = caml.unice.fr ou vide si on est en local");
            System.exit(0);
        }//else if

        try{
                        
           new Client();
        }catch(Exception e){System.out.println("Exception main de Client ");}
    }//fin main


 /**
       active ou desactive le bouton "Help" de la classe AireDeJeu
     */
    public void setEnableHelp(boolean b){
        gg.setEnableHelp(b);
    }//public void setEnableHelp(boolean b)



    /***********************************************
                  Mthodes Distantes
   ***********************************************/


   /**
      Ractualise la grille avec une nouvelle matrice 
      @param tab la nouvelle matrice  dessiner
   */   
   public void refreshClient(int[][] tab){      
      gg.refreshClient(tab);
   }

    public void refreshClient(){
        gg.refreshClient();
    }//fin refreshClient()



  /**
      Ajoute ou enleve les listener
      @param b booleen permettant d'ajouter (true) ou d'enlever (false) les listeners
   */
  public void setListener(boolean b){
    gg.setListener(b);
  }//fin setListener

  /**
      Accesseur de la variable joueur
      @return Le numro de joueur associ  l'aire de jeu    
  */
  public int getJoueur(){
    return gg.getJoueur();
  }//fin getJoueur


  /**
      Modifieur de la variable joueur
      @param joueur le nouveau numro de joueur
  */
  public void setJoueur(int joueur){
    gg.setJoueur(joueur);
  }//fin getJoueur



/**
      Bloque les vnements souris et le bouton OK de la fentre.       
  */
  public void setEventOff(){
      gg.setEventOff();
  }//fin setEventOff  



/**
      Dbloque les vnements souris et le bouton OK de la fentre.       
  */
  public void setEventOn(){
      gg.setEventOn();
  }//fin setEventOff   

  /**
      Affiche un message d'alerte provenant du serveur
  */
  public void messageAlerte(String message){
      gg.messageAlerte(message);
  }//fin messageAlerte


    /***********************************************
                  Mthodes membres
   ***********************************************/
   
    /**
         Joue la colonne slectionne soit par la souis soit par le TextField
         @param colonne la colonne  jouer
    */
    private void traitement(int colonne){
       try{    
          if(p.colonnePleine(colonne)){
             Alerte a=new Alerte(f,"Colonne pleine, jouer une autre colonne...");
          }
          else{
              p.changeJoueurActif();       
              p.jouerLaColonne(p.getJoueurActif(),colonne); 
          }//fin else colonnePleine
       }catch(Exception ex){
       System.out.println("Exception declenchee par traitement du Client ");
       ex.printStackTrace();}
   }//fin traitement()
   
   
   
   /***********************************************
      Implmentation de l'interface MouseListener
   ***********************************************/

    /**
      Gre les clics souris.
      @param me l'vnement  grer
    */
    public void mouseClicked(MouseEvent me){
      try{  
      //le joueur slectionne une colonne par un double clic
        if(me.getClickCount() >= 2){ 
            int x=me.getX();
            int y=me.getY();
            int ggH=gg.getGrilleHeight();
            int ggW=gg.getGrilleWidth();
            int lCase=ggW/7;
            
          if(!p.partieTerminee()){ 

            if(x>0 && x<lCase){  //colonne 1
               traitement(1);     
            }
            if(x>lCase && x<(lCase*2)){  //colonne 2
               traitement(2);     
            }
            if(x>(lCase*2) && x<(lCase*3)){ //colonne 3
               traitement(3);     
            }
            if(x>(lCase*3) && x<(lCase*4)){ //colonne 4
               traitement(4);     
            }
            if(x>(lCase*4) && x<(lCase*5)){ //colonne 5
               traitement(5);     
            }
            if(x>(lCase*5) && x<(lCase*6)){ //colonne 6
               traitement(6);     
            }
            if(x>(lCase*6) && x<(lCase*7)){ //colonne 7
               traitement(7);     
            }
          }//fin  if(!p.partieTerminee())
       }//fin if clickCount
      }catch(Exception ex){
         System.out.println("Exception declenchee par mouseClicked Client ");
         ex.printStackTrace();}
    }//fin mouseClicked()


    /**
      Gre l'entre de la souris sur le canvas, le curseur change de forme.
      @param me l'vnement  grer
    */
    public void mouseEntered(MouseEvent e){
      gg.setCursor(new Cursor(Cursor.HAND_CURSOR));
    }//fin mouseEntered

    /**
      Gre la sortie de la souris du le canvas, le curseur change de forme.
      @param me l'vnement  grer
    */
    public void mouseExited(MouseEvent e){
      gg.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }//fin mousExited

    public void mousePressed(MouseEvent e){}

    public void mouseReleased(MouseEvent e){}
    
    
    
   /***********************************************
      Implmentation de l'interface ActionListener
   ***********************************************/
    /**
      Gre les vnements des boutons
      @param me l'vnement  grer
    */
    public void actionPerformed(ActionEvent ae){
        String arg=ae.getActionCommand();
        //Object source = ae.getSource();
        if(arg.equals("OK")){
            try{
               //saisie du numro de colonne
               int nb=Integer.parseInt(new String(gg.getTextField().getText()));               
               if((nb<=7 && nb>=1) && (!p.partieTerminee()))traitement(nb); 
               else {Alerte a= new Alerte(f,"Entrer un entier entre 1 et 7");}
               gg.getTextField().setText("");    
               gg.getTextField().requestFocus();
            } catch(Exception ex){
               gg.getTextField().setText("");    
               gg.getTextField().requestFocus();
               Alerte a= new Alerte(f,"Saisir un entier entre 1 et 7");   
            }//fin catch     
        }//fin if(arg.equals("bOk")


        if(arg.equals("Nouvelle partie")){
            //if(arg.equals("Nouveau")){
          try{
            //bloque la gestion des vnements si ce n'est pas  ce joueur 
            //de commencer la nouvelle partie
            if(gg.getJoueur()!=p.getJoueurActif()) gg.setEventOff();
            p.reset();            
          }catch(Exception ex){
          System.out.println("Exception declenchee par actionPerfomed Nouvelle partie du Client ");
          ex.printStackTrace();}
        }

        
        if(arg.equals("Quitter")){
         try{
            //enleve le client du vecteur des clients sur le serveur
            p.removeClient(gg.getJoueur());
            //ferme la fentre
            System.exit(0); 
         }catch(Exception ex){
          System.out.println("Exception declenchee par actionPerfomed Quitter du Client ");
          ex.printStackTrace();}           
        }//fin if(arg.equals("bOk")




        if(arg.equals("Help")){
         try{
            fH = new Help(f,this);
            gg.setEnableHelp(false);
            fH.setVisible(true);    
         }catch(Exception ex){
          System.out.println("Exception declenchee par actionPerfomed Help du Client ");
          ex.printStackTrace();}           
        }//fin if(arg.equals("bOk")
        
    }//fin actionPerformed
    
    
    
   /***********************************************
      Implmentation de l'interface WindowListener
   ***********************************************/    
    public void windowOpened(WindowEvent e){}

    public void windowClosing(WindowEvent e){System.exit(0);}

    public void windowClosed(WindowEvent e){System.exit(0);}

    public void windowIconified(WindowEvent e){}

    public void windowDeiconified(WindowEvent e){}

    public void windowActivated(WindowEvent e){}

    public void windowDeactivated(WindowEvent e){}
 
 
 
  
 
}//fin TestGraphique
