import java.awt.*;
import java.awt.event.*;

/**
   Classe permettant d'afficher une bote de dialogue avec un message informatif.
   Un bouton permet de fermer la boite.
*/
public class Alerte extends Dialog implements ActionListener{

   Button bouton=new Button("OK");     //le bouton permmettant de fermer la boite de dialogue
   

   /**
      Constructeur
      @param parent la fentre parente
      @param msg le message  afficher
   */
   public Alerte(Frame parent, String msg){
      super(parent,"Puissance 4",false);
      //Layout gnral et couleurs
      setLayout(new GridLayout(2,1));
      setBackground(Color.lightGray);
      setForeground(Color.red);
      bouton.setBackground(Color.lightGray);
      bouton.setForeground(Color.black);
      
      //Listener
       bouton.addActionListener(this);
       
      //Ajout des composants      
      Panel p1=new Panel();
      Label message=new Label(msg);
      p1.add(message);
      add(p1);
      
      Panel p2=new Panel();
      p2.add(bouton);
      add(p2);
      
      //Determine la taille et la position par rapport  la fentre mre
      pack();
      setLocation((parent.getSize().width/2)-(getSize().width/2)+parent.getLocation().x,(parent.getSize().height/2)-(getSize().height/2)+parent.getLocation().y);
      setVisible(true);
   }//fin constructeur
   
   
   /**
      Gre les vnements de la boite de dialogue
      @param ae l'vnement  grer
   */   
   public void actionPerformed(ActionEvent ae){
      Object source=ae.getSource();
      if(source==bouton) dispose();
   }//fin actionPerformed



}//fin class Alerte
