import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import java.rmi.server.*;

/**
 Classe implmentant l'aire de jeu graphique. Cet objet se trouve chez le client.<BR>
 L'interface graphique est constitue d'un panel gnral (InnerAireDeJeu). Ce panel contient un Canvas (GrilleGraphique)
 qui dfinit la grille de jeu, et un panel contenant les boutons.
 */
public class AireDeJeu {

   private InnerAireDeJeu iaj; //panel dessinant la grille de jeu et les boutons
   private Frame f;            //fentre contenant le panel
   private int joueur;         //numro du joueur associer  cette objet graphique
   private boolean isListened=true; //determine si les listeners sont activs
  private int[][] tab;    //tableau  dessiner

   /**Constructeur
      @param ae actionListener associ aux boutons
      @param me mouseListener associ  la grille de jeu
      @param tab la matrice  dessiner
   */
   public AireDeJeu(ActionListener ae, MouseListener me, int[][] tab) {
      try{
         this.tab=tab;
         iaj=new InnerAireDeJeu(ae,me,tab);
         f=new Frame();      
         f.setLocation(100,100);
         f.add(iaj);
         f.pack();        
         f.setSize(f.getSize().width,f.getSize().width);
         f.setResizable(false);        
      }catch(Exception ex){
         System.out.println("Exception declenchee par le constructeur de AireDeJeu ");
         ex.printStackTrace();}
      
   }//fin constructeur
   
   /*******************************************************/
   /*                   Mthodes membres                  */
   /*******************************************************/


    /**
       active ou desactive le bouton "Help"
     */
    public void setEnableHelp(boolean b){
        iaj.setEnableHelp(b);
    }//public void setEnableHelp(boolean b)


   /**
      Retourne la Frame d'affichage
      @return La fentre   
   */
   public Frame getFrame(){
      return f;
   }//fin getFrame
   
   
   /**
      Accesseur au TextField de l'aire de jeu
      @return La zone de saisie du numro de colonne de l'aire de jeu
   */
   public TextField getTextField(){
      return iaj.getTextField();
   }//fin getTextField
   
   
   /**
      Retourne la hauteur courante du canvas GrilleGraphique contenu dans InnerAireDeJeu
      @return La hauteur courante
   */    
   public int getGrilleHeight(){
      return iaj.getGrilleHeight();
   }//fin getGrilleHeight
   
   
   /**
      Retourne la largeur courante du canvas GrilleGraphique contenu dans InnerAireDeJeu
      @param La largeur courante   
   */    
   public int getGrilleWidth(){
       return iaj.getGrilleWidth();
   }//fin getGrilleHeight
   
   
   /** 
      Change le curseur
      @cur le nouveau curseur de souris  employer   
   */
   public void setCursor(Cursor cur){
      iaj.setCursor(cur);
   }
   
  
  /**
      Repaint l'aire de jeu
  */
  public void repaint(){
    iaj.repaint();
  }//fin repaint 
  
  
   /*******************************************************/
   /*      Implmentation de l'interface AireDistant      */
   /*******************************************************/
   /**
      Ractualise la grille avec une nouvelle matrice 
      @param tab la nouvelle matrice  dessiner
   */   
   public void refreshClient(int[][] tab){      
      iaj.change(tab);
   }
  
  public void refreshClient(){
    iaj.change(tab);
  }//fin refreshClient()
  /**
      Ajoute ou enleve les listener
      @param b booleen permettant d'ajouter (true) ou d'enlever (false) les listeners
   */
  public void setListener(boolean b){
    iaj.setListener(b);
  }//fin setListener

  /**
      Accesseur de la variable joueur
      @return Le numro de joueur associ  l'aire de jeu    
  */
  public int getJoueur(){
    return joueur;
  }//fin getJoueur

  /**
      Modifieur de la variable joueur
      @param joueur le nouveau numro de joueur
  */
  public void setJoueur(int joueur){
    this.joueur=joueur;
  }//fin getJoueur
  
   
  /**
      Bloque les vnements souris et le bouton OK de la fentre.       
  */
  public void setEventOff(){
    if (isListened){
       iaj.setEventOff();
       isListened=false;
    }
  }//fin setEventOff  
  
            
  /**
      Dbloque les vnements souris et le bouton OK de la fentre.       
  */
  public void setEventOn(){
     if(!isListened){
        iaj.setEventOn();                  
        isListened=true;
     }
  }//fin setEventOff   
  
  
  /**
      Affiche un message d'alerte provenant du serveur
  */
  public void messageAlerte(String message){
      Alerte a=new Alerte(f,message);
  }//fin messageAlerte
  
  
  
   /*******************************************************/
   /*                    INNER  CLASS                     */
   /*                   InnerAireDeJeu                    */
   /*******************************************************/   
   
   /**
      Panel contenant un canvas pour l'affichage de la grille de jeu et un panel contenant les boutons.
      La grille de jeu rpond  des vnements du type clic souris
   */
   public class InnerAireDeJeu extends Panel{
   
       private TextField tf=new TextField(1);   //zone de saisie en mode texte de la colonne  jouer
       private Label lbl1=new Label("Numero de colonne "); //Label du TextField tf
       private Button bOk=new Button("OK");  //Bouton ok pour valider la saisie dans le TextField
       private Button bNouvPartie=new Button("Nouvelle partie");  //Bouton pour remettre  vide la grille de jeu
       //private Button bNouvPartie=new Button("Nouveau");  //Bouton pour remettre  vide la grille de jeu
       private Button bQuitter=new Button("Quitter");  //Bouton pour fermer la fentre
       private GrilleGraphique gg; //Canvas dfinissant la grille de jeu
       private int[][] tab; //La matrice  afficher
       private ActionListener ae; //L'actionListener associ aux boutons
       private MouseListener me; //MouseListener associ au Canvas
       private Button bHelp = new Button("Help"); //buouton help (aide en ligne)

       /**
         Constructeur.
         @param ae l'ActionListener associ aux boutons
         @param me le MouseListener associ au Canvas
         @param tab la matrice  afficher
       */
       public InnerAireDeJeu(ActionListener ae, MouseListener me, int[][] tab){
           
           /* Initialistaions */
           this.tab=tab;        
           this.ae=ae;
           this.me=me;
           gg=new GrilleGraphique(tab);
                   
           /* Ajout des Listeners */
           gg.addMouseListener(me);
           bOk.addActionListener(ae);
           bNouvPartie.addActionListener(ae);
           bQuitter.addActionListener(ae);       
           bHelp.addActionListener(ae);       
      
           /* Layout gnral et couleurs */        
           setLayout(new BorderLayout());
           setBackground(Color.black);
           bOk.setBackground(Color.lightGray);
           bNouvPartie.setBackground(Color.lightGray);
           bQuitter.setBackground(Color.lightGray);        
           bHelp.setBackground(Color.lightGray);        
           tf.setBackground(Color.lightGray);
           lbl1.setForeground(Color.lightGray);
           
           /* Ajout des composants*/
           Panel p1=new Panel();          
           p1.setBackground(Color.black);
           p1.setForeground(Color.lightGray);          
           add(p1,"North");
      
           Panel p2=new Panel();
           p2.setBackground(Color.black);
           add(p2,"East");
   
           Panel p3=new Panel();
           p3.setBackground(Color.black);
           add(p3,"West");
      
           Panel p4=new Panel();
           p4.add(lbl1);
           p4.add(tf);
           p4.add(bOk);
           p4.add(bNouvPartie);
           p4.add(bHelp);
           p4.add(bQuitter);
           add(p4,"South");
                   
           add(gg,"Center");
           
       }//fin constructeur
   
   
   
      /*******************************************************/
      /*                   Mthodes membres                  */
      /*******************************************************/

       /**
          active ou desactive le bouton "Help"
       */
       public void setEnableHelp(boolean b){
           bHelp.setEnabled(b);
       }//public void setEnableHelp(boolean b)




      /** 
         Accesseur au TextField de l'aire de jeu
         @return Le TextField du panel
      */
       public TextField getTextField(){
         return tf;
       }//fin getTextField
   
       /**
         Retourne la hauteur courante du canvas GrilleGraphique contenu dans AireDeJeu
         @return La hauteur courante
        */    
       public int getGrilleHeight(){
           return gg.getHeight();
       }//fin getGrilleHeight
   
       /**
         Retourne la largeur courante du canvas GrilleGraphique contenu dans AireDeJeu
         @return La largeur courante
       */    
       public int getGrilleWidth(){
           return gg.getWidth();
       }//fin getGrilleHeight
   
       /**
         Ractulise la grille avec une nouvelle matrice 
         @param tab la nouvelle matrice
        */   
       public void change(int[][] tab){      
         gg.setTab(tab);
         gg.repaint();
       }
       
       /**
         Ajoute ou enleve les listener
         @param b boolen permettant d'ajouter (true) ou d'enlever (false)
       */
       public void setListener(boolean b){
         if(b) {
           if (!isListened) gg.addMouseListener(me);
           bOk.setEnabled(true);
           bNouvPartie.setEnabled(true);           
           tf.setEditable(true);
           lbl1.setEnabled(true);
           isListened=true;           
         }//fin if
         else{
           if(isListened) gg.removeMouseListener(me);
           bOk.setEnabled(false);
           bNouvPartie.setEnabled(false);                      
           tf.setEditable(false);
           lbl1.setEnabled(false);  
           isListened=true;
         }
       }//fin setListener
     
       
       /**
         Bloque les vnements souris et le bouton OK du panel
        */
       public void setEventOff(){
         gg.removeMouseListener(me);         
         bOk.setEnabled(false);                       
       }//fin setEventOff   
       
       
       /**
         Dbloque les vnements souris et le bouton OK du panel
       */
       public void setEventOn(){
         gg.addMouseListener(me);         
         bOk.setEnabled(true);                     
       }//fin setEventOff   
       
       
      /*******************************************************/
      /*                    INNER CLASS                      */
      /*                  GrilleGraphique                    */
      /*******************************************************/
      
      /** 
         Classe GrilleGraphique : dfinit la grille de jeu de 6 cases par 7
      */
       public class GrilleGraphique extends Canvas{
           private int[][] tab;
           
           /**
            Constructeur
            @param la matrice  afficher
           */
           public GrilleGraphique(int[][] tab){
               setBackground(Color.lightGray);
               this.tab=tab;
           }//fin constructeur
           
         /*******************************************************/
         /*                   Mthodes membres                  */
         /*******************************************************/
           
           /** 
            Retourne la taille optimale de la grille
            @return Un objet Dimension
           */        
           public Dimension getPreferredSize(){
               return new Dimension(200,200);
           }//fin getPreferredSize()
           
           /** 
            Retourne la taille minimum de la grille
            @return Un objet Dimension
           */
           public Dimension getMinimumSize(){
               return new Dimension(200,200);
           }//fin getMinimumSize
   
   
           /**
            Retourne la hauteur courante de la grille
            @return La hauteur courante
           */        
           public int getHeight(){
            return getSize().height;
           }//fin getHeight
   
           /**
            Retourne la largeur courante de la grille
            @return La largeur courante
           */
           public int getWidth(){
               return getSize().width;
           }//fin getWidth
   
           /** 
            Modifieur de la matrice associe  la grille
            @param tab la nouvelle matrice
           */                 
           public void setTab(int[][] tab){
               this.tab=tab;
           }//fin setTab
           
           
           /** 
            Paint la grille en fonction de la matrice 
            @param gr le contexte graphique du panel
           */        
           public void paint(Graphics gr){
               gr.setColor(Color.black);
               
               int hauteur=getSize().height;
               int largeur=getSize().width;
               int h=hauteur/7;
               int l=largeur/7;
               
               
               //Affichage de la grille de jeu
               gr.setColor(Color.black);
               for(int j=0;j<6; j++){
                   for(int i=0; i<7;i++){
                       gr.drawRect((i*l)+1,(j*h)+1,l-2,h-2);                  
                       //gr.fillOval((i*l)+2,(j*h)+2,l-4,h-4);
                   }//fin for
               }//fin for
   
   
               //Affichage des pions            
               for(int j=1;j<6+1;j++){
                   for(int i=1;i<7+1;i++){
                      if(tab[i][j]==1){
                         gr.setColor(Color.orange);
                         gr.fillOval(((i-1)*l)+2,((j-1)*h)+2,l-4,h-4);
                      }
                      else if(tab[i][j]==2){
                         gr.setColor(Color.blue);
                         gr.fillOval(((i-1)*l)+2,((j-1)*h)+2,l-4,h-4);
                      }
                   }//for(int i=0;i<7;i++)
                    
               }//for(int j=0;j<6;j++)   
               
               
               //Affichage de numros de colonne, redimensionnables            
               Font myfont=new Font("Arial",Font.PLAIN,14);
               gr.setFont(myfont);
               FontMetrics fm=getFontMetrics(myfont); 
               gr.setColor(Color.black);            
               for (int i=0;i<7;i++){
                   String tbs=new Integer(i+1).toString();
                   int xs=(i*l)+(l/2)-(fm.stringWidth(tbs)/2);
                   gr.drawString(tbs,xs,(h*6)+fm.getHeight());
               }//fin for
               Font myfont2=new Font("Arial",Font.PLAIN,12);               
               gr.setFont(myfont2);
               if(joueur==2)
                  gr.drawString("Vous etes le joueur jaune",2,(h*6)+2*fm.getHeight());
               
               if(joueur==1)
                  gr.drawString("Vous etes le joueur bleu",2,(h*6)+2*fm.getHeight());           
                 
               if(joueur>2)
                  gr.drawString("Deux joueurs sont dj connects..." ,2,(h*6)+2*fm.getHeight());                         
         }//fin paint
           
       }//fin GrilleGraphique
   
       /*******************FIN INNER CLASS***********************/
   
   }//fin InnerAireDeJeu

}//fin AireDeJeu




