import com.sun.java.swing.*;
import com.sun.java.swing.filechooser.*;
import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import CBzip;
import CBunzip;
import ExampleFileFilter;

/**
 * classe de gestion de l'interface pour winzip
 * creee en partie par Visual Age (une toute petite partie...)
 * l'interface de notre zippeur
 * @author C.Baeumler & B.Luttringer (& un peu Visual Age)
 */

public class ZipInterface {

    private JFrame JFrame1 = null;
    private JMenuBar JFrame1JMenuBar = null;
    private JPanel JFrameContentPane = null;
    private JMenu JMenu1 = null;
    private JMenuItem JMenuItem1 = null;
    private JMenuItem JMenuItem2 = null;
    private JMenuItem JMenuItem3 = null;
    private JMenuItem JMenuItem4 = null;
    private JMenuItem JMenuItem5 = null;
    private JMenuItem JMenuItem6 = null;
    private JSeparator JSeparator1 = null;
    private JButton JToolBarButton1 = null;
    private JButton JToolBarButton2 = null;
    private JButton JToolBarButton3 = null;
    private JButton JToolBarButton4 = null;
    private JButton JToolBarButton5 = null;
    private JLabel JLabel1 = null;
    private JLabel JLabel2 = null;
    private JLabel JLabel3 = null;
    private java.awt.List List1 = null;
    private java.awt.List List2 = null;
    private java.awt.List List3 = null;

    private Operations archiveCourante;
    private CBzip cbzip;
    private CBunzip cbunzip;
    private Vector fileList;
    
    /**
     * Constructeur
     */

    public ZipInterface() {
	super();
	fileList = new Vector();
	initialize();
    }

    /**
     * Initialize the class.
     */

    private void initialize() {

	getJFrame1().setVisible(true);
	getJFrame1JMenuBar().setVisible(true);
	getJFrameContentPane().setVisible(true);
	getJMenu1().setVisible(true);
	getJMenuItem1().setVisible(true);
	getJMenuItem2().setVisible(true);
	getJMenuItem3().setVisible(true);
	getJMenuItem4().setVisible(true);
	getJMenuItem5().setVisible(true);
	getJMenuItem6().setVisible(true);
	getJToolBarButton1().setVisible(true);
	getJToolBarButton2().setVisible(true);
	getJToolBarButton3().setVisible(true);
	getJToolBarButton4().setVisible(true);
	getJLabel1().setVisible(true);
	getJLabel2().setVisible(true);
	getJLabel3().setVisible(true);
    }

    /**
     * Return the JFrame1 property value.
     * @return JFrame
     */

    private JFrame getJFrame1() {

	if (JFrame1 == null) {
	    try {
		JFrame1 = new JFrame();
		JFrame1.setName("JFrame1");
		JFrame1.setTitle("CBzip");
		JFrame1.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		JFrame1.setBounds(100, 100, 375, 315);
		JFrame1.setJMenuBar(getJFrame1JMenuBar());
		JFrame1.setResizable(false);
		getJFrame1().setContentPane(getJFrameContentPane());
		// user code begin {1}
		// user code end
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JFrame1;
    }


 /** 
     * Gestion des Menus deroulants
     */


    /**
     * Return the JFrame1JMenuBar property value.
     * @return JMenuBar
     */

    private JMenuBar getJFrame1JMenuBar() {
	if (JFrame1JMenuBar == null) {
	    try {
		JFrame1JMenuBar = new JMenuBar();
		JFrame1JMenuBar.setName("JFrame1JMenuBar");
		JFrame1JMenuBar.add(getJMenu1());
		// user code begin {1}
		// user code end
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JFrame1JMenuBar;
    }


    /**
     * Return the JMenu1 property value.
     * @return JMenu
     */

    private JMenu getJMenu1() {
	if (JMenu1 == null) {
	    try {
		JMenu1 = new JMenu();
		JMenu1.setName("JMenu1");
		JMenu1.setText("File");
		JMenu1.add(getJMenuItem1());
		JMenu1.add(getJMenuItem2());
		JMenu1.add(getJMenuItem3());
		JMenu1.add(getJMenuItem4());
		JMenu1.add(getJMenuItem5());
		JMenu1.add(getJSeparator1());
		JMenu1.add(getJMenuItem6());
		
		// user code begin {1}
		// user code end
	    } catch (java.lang.Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JMenu1;
    }
    

    /**
     * Method generated to support the promotion of the JMenu1Size attribute.
     * @param arg1 Dimension
     */

    public void setJMenu1Size(Dimension arg1) {
	getJMenu1().setSize(arg1);
    }

    /**
     * Method generated to support the promotion of the JMenu1Text attribute.
     * @param arg1 String
     */

    public void setJMenu1Text(String arg1) {
	getJMenu1().setText(arg1);
    }

    /**
     * Method generated to support the promotion of the JMenu1Size attribute.
     * @return Dimension
     */

    public Dimension getJMenu1Size() {
	return getJMenu1().getSize();
    }

    /**
     * Method generated to support the promotion of the JMenu1Text attribute.
     * @return String
     */

    public String getJMenu1Text() {
	return getJMenu1().getText();
    }

    /**
     * Return the JMenuItem1 property value.
     * @return com.sun.java.swing.JMenuItem
     */
    
    private JMenuItem getJMenuItem1() {
	if (JMenuItem1 == null) {
	    try {
		JMenuItem1 = new JMenuItem();
		JMenuItem1.setName("JMenuItem1");
		JMenuItem1.setText("New");
		JMenuItem1.addActionListener(actionAdaptor1 = new ActionAdaptor1());
		// user code begin {1}
		// user code end
	    } catch (java.lang.Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JMenuItem1;
    }

    /**
     * Return the JMenuItem2 property value.
     * @return com.sun.java.swing.JMenuItem
     */
    
    private JMenuItem getJMenuItem2() {
	if (JMenuItem2 == null) {
	    try {
		JMenuItem2 = new JMenuItem();
		JMenuItem2.setName("JMenuItem2");
		JMenuItem2.setText("Open");
		JMenuItem2.addActionListener(actionAdaptor2 = new ActionAdaptor2());
		// user code begin {1}
		// user code end
	    } catch (java.lang.Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JMenuItem2;
    }

    /**
     * Return the JMenuItem3 property value.
     * @return com.sun.java.swing.JMenuItem
     */
    
    private JMenuItem getJMenuItem3() {
	if (JMenuItem3 == null) {
	    try {
		JMenuItem3 = new JMenuItem();
		JMenuItem3.setName("JMenuItem3");
		JMenuItem3.setText("Add");
		JMenuItem3.addActionListener(actionAdaptor3 = new ActionAdaptor3());
		// user code begin {1}
		// user code end
	    } catch (java.lang.Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JMenuItem3;
    }

    /**
     * Return the JMenuItem4 property value.
     * @return com.sun.java.swing.JMenuItem
     */
    
    private JMenuItem getJMenuItem4() {
	if (JMenuItem4 == null) {
	    try {
		JMenuItem4 = new JMenuItem();
		JMenuItem4.setName("JMenuItem4");
		JMenuItem4.setText("Extract");
		JMenuItem4.addActionListener(actionAdaptor4 = new ActionAdaptor4());
		// user code begin {1}
		// user code end
	    } catch (java.lang.Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JMenuItem4;
    }


    /**
 * Return the JMenuItem5 property value.
 * @return com.sun.java.swing.JMenuItem
 */

    private JMenuItem getJMenuItem5() {
	if (JMenuItem5 == null) {
	    try {
		JMenuItem5 = new JMenuItem();
		JMenuItem5.setName("JMenuItem5");
		JMenuItem5.setText("Delete");
		JMenuItem5.addActionListener(actionAdaptor5 = new ActionAdaptor5());
		// user code begin {1}
		// user code end
	    } catch (java.lang.Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JMenuItem5;
    }


    /**
     * Return the JMenuItem6 property value.
     * @return com.sun.java.swing.JMenuItem
     */
    
    private JMenuItem getJMenuItem6() {
	if (JMenuItem6 == null) {
	    try {
		JMenuItem6 = new JMenuItem();
		JMenuItem6.setName("JMenuItem6");
		JMenuItem6.setText("Exit");
		JMenuItem6.addActionListener(actionAdaptor6=new ActionAdaptor6());
		// user code begin {1}
		// user code end
	    } catch (java.lang.Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JMenuItem6;
    }
    

    /**
 * Return the JSeparator1 property value.
 * @return com.sun.java.swing.JSeparator
 */

    private JSeparator getJSeparator1() {
	if (JSeparator1 == null) {
	    try {
		JSeparator1 = new JSeparator();
		JSeparator1.setName("JSeparator1");
		// user code begin {1}
		// user code end
	    } catch (java.lang.Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JSeparator1;
    }


    /** 
     * Gestion des boutons
     */


    /**
     * Return the JToolBarButton1 property value.
     * @return com.sun.java.swing.JButton
     */
    
    private JButton getJToolBarButton1() {
	if (JToolBarButton1 == null) {
	    try {
		JToolBarButton1 = new JButton();
		JToolBarButton1.setName("JToolBarButton1");
		JToolBarButton1.setText("");
		JToolBarButton1.setHorizontalTextPosition(com.sun.java.swing.SwingConstants.CENTER);
		JToolBarButton1.setVerticalTextPosition(com.sun.java.swing.SwingConstants.BOTTOM);
		JToolBarButton1.setIcon(new ImageIcon("icones/new.jpg"));
		JToolBarButton1.setMargin(new Insets(0, 0, 0, 0));
		JToolBarButton1.setBounds(5, 38, 40, 40);
		JToolBarButton1.addActionListener(actionAdaptor1 = new ActionAdaptor1());
		// user code begin {1}
		// user code end
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JToolBarButton1;
    }

    /**
     * Return the JToolBarButton1 property value.
     * @return com.sun.java.swing.JButton
     */

    private JButton getJToolBarButton2() {
	if (JToolBarButton2 == null) {
		try {
			JToolBarButton2 = new JButton();
			JToolBarButton2.setName("JToolBarButton1");
			JToolBarButton2.setText("");
			JToolBarButton2.setHorizontalTextPosition(SwingConstants.CENTER);
			JToolBarButton2.setVerticalTextPosition(SwingConstants.BOTTOM);
			JToolBarButton2.setIcon(new ImageIcon("icones/open.jpg"));
			JToolBarButton2.setMargin(new Insets(0, 0, 0, 0));
			JToolBarButton2.setBounds(5, 80, 40, 40);
			JToolBarButton2.addActionListener(actionAdaptor2 = new ActionAdaptor2());
			// user code begin {1}
			// user code end
		} catch (Throwable Exc) {
		    // user code begin {2}
		    // user code end
		    handleException(Exc);
		}
	};
	return JToolBarButton2;
    }
    
    /**
     * Return the JToolBarButton1 property value.
     * @return com.sun.java.swing.JButton
     */
    
    private JButton getJToolBarButton3() {
	if (JToolBarButton3 == null) {
		try {
		    JToolBarButton3 = new JButton();
			JToolBarButton3.setName("JToolBarButton3");
			JToolBarButton3.setText("");
			JToolBarButton3.setHorizontalTextPosition(SwingConstants.CENTER);
			JToolBarButton3.setVerticalTextPosition(SwingConstants.BOTTOM);
			JToolBarButton3.setIcon(new ImageIcon("icones/add.jpg"));
			JToolBarButton3.setMargin(new Insets(0, 0, 0, 0));
			JToolBarButton3.setBounds(5, 122, 40, 40);
			JToolBarButton3.addActionListener(actionAdaptor3 = new ActionAdaptor3());
			// user code begin {1}
			// user code end
		} catch (Throwable Exc) {
		    // user code begin {2}
		    // user code end
		    handleException(Exc);
		}
	};
	return JToolBarButton3;
    }

    
    /**
     * Return the JToolBarButton1 property value.
     * @return com.sun.java.swing.JButton
     */
    
    private JButton getJToolBarButton4() {
	if (JToolBarButton4 == null) {
		try {
		    JToolBarButton4 = new JButton();
		    JToolBarButton4.setName("JToolBarButton4");
		    JToolBarButton4.setText("");
		    JToolBarButton4.setHorizontalTextPosition(SwingConstants.CENTER);
		    JToolBarButton4.setVerticalTextPosition(SwingConstants.BOTTOM);
		    JToolBarButton4.setIcon(new ImageIcon("icones/extract.jpg"));
		    JToolBarButton4.setMargin(new Insets(0, 0, 0, 0));
		    JToolBarButton4.setBounds(5, 164, 40, 40);
		    JToolBarButton4.addActionListener(actionAdaptor4 = new ActionAdaptor4());
		    // user code begin {1}
		    // user code end
		} catch (Throwable Exc) {
		    // user code begin {2}
		    // user code end
		    handleException(Exc);
		}
	};
	return JToolBarButton4;
    }


    /**
     * Return the JToolBarButton1 property value.
     * @return com.sun.java.swing.JButton
     */
    
    private JButton getJToolBarButton5() {
	if (JToolBarButton5 == null) {
	    try {
		JToolBarButton5 = new JButton();
		JToolBarButton5.setName("JToolBarButton5");
		JToolBarButton5.setText("");
		JToolBarButton5.setHorizontalTextPosition(SwingConstants.CENTER);
		JToolBarButton5.setVerticalTextPosition(SwingConstants.BOTTOM);
		JToolBarButton5.setIcon(new ImageIcon("icones/delete.jpg"));
		JToolBarButton5.setMargin(new Insets(0, 0, 0, 0));
		JToolBarButton5.setBounds(5, 206, 40, 40);
		JToolBarButton5.addActionListener(actionAdaptor5 = new ActionAdaptor5());
		// user code begin {1}
		// user code end
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JToolBarButton5;
    }
    

    
    /**
     *  Gestion de l'affichage des fichiers
     */


    /**
     * Return the JLabel1 property value.
     * @return com.sun.java.swing.JLabel
     */
   
    private JLabel getJLabel1() {
	if (JLabel1 == null) {
	    try {
		JLabel1 = new JLabel();
		JLabel1.setName("JLabel1");
		JLabel1.setText(" nom ");
		JLabel1.setBounds(80, 15, 150, 20);
		// user code begin {1}
		// user code end
	    } catch (java.lang.Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JLabel1;
    }

    /**
     * Return the JLabel2 property value.
     * @return com.sun.java.swing.JLabel
     */
    
    private JLabel getJLabel2() {
	if (JLabel2 == null) {
	    try {
		JLabel2 = new JLabel();
		JLabel2.setName("JLabel2");
		JLabel2.setText(" taille");
		JLabel2.setBounds(231, 15, 50, 20);
		// user code begin {1}
		// user code end
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JLabel2;
    }

    /**
     * Return the JLabel3 property value.
     * @return com.sun.java.swing.JLabel
     */
    
    private JLabel getJLabel3() {
	if (JLabel3 == null) {
	    try {
		JLabel3 = new JLabel();
		JLabel3.setName("JLabel3");
		JLabel3.setText(" ratio");

		
		JLabel3.setBounds(282, 15, 50, 20);
		// user code begin {1}
		// user code end
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JLabel3;
    }
    
    /**
     * Return the List1 property value.
     * @return com.sun.java.swing.List
     */

    private java.awt.List getList1() {
	if (List1 == null) {
	    try {
		List1 = new java.awt.List(10,false);
		List1.setName("List1");
		List1.setSize(150,200);
		List1.setBounds(80, 37, 150, 200);
		// user code begin {1}
		// user code end
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
		}
	};
	return List1;
    }
    

    /**
     * Return the List2 property value.
     * @return com.sun.java.swing.List
     */

    private java.awt.List getList2() {
	if (List2 == null) {
	    try {
		List2 = new java.awt.List(10,false);
		List2.setName("List2");
		List2.setSize(150,200);
		List2.setBounds(231, 37, 50, 200);
		// user code begin {1}
		// user code end
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return List2;
    }
    
    /**
     * Return the List2 property value.
     * @return com.sun.java.swing.List
     */

    private java.awt.List getList3() {
	if (List3 == null) {
	    try {
		List3 = new java.awt.List(10,false);
		List3.setName("List3");
		List3.setSize(150,200);
		List3.setBounds(282, 37, 50, 200);
		// user code begin {1}
		// user code end
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return List3;
    }

    /** 
     * Gestion de le frame principale
     */
    
    
    /**
     * Return the JFrameContentPane property value.
     * @return com.sun.java.swing.JPanel
     */
    
    private JPanel getJFrameContentPane() {
	if (JFrameContentPane == null) {
	    try {
		JFrameContentPane = new JPanel();
		JFrameContentPane.setName("JFrameContentPane");
		JFrameContentPane.setLayout(null);
		getJFrameContentPane().add(getJToolBarButton1(), getJToolBarButton1().getName());
		getJFrameContentPane().add(getJToolBarButton2(), getJToolBarButton2().getName());
		getJFrameContentPane().add(getJToolBarButton3(), getJToolBarButton3().getName());
		getJFrameContentPane().add(getJToolBarButton4(), getJToolBarButton4().getName());
		getJFrameContentPane().add(getJToolBarButton5(), getJToolBarButton5().getName());
		getJFrameContentPane().add(getJLabel1(), getJLabel1().getName());
		getJFrameContentPane().add(getJLabel2(), getJLabel2().getName());
		getJFrameContentPane().add(getJLabel3(), getJLabel3().getName());
		getJFrameContentPane().add(getList1(), getList1().getName());
		getJFrameContentPane().add(getList2(), getList2().getName());
		getJFrameContentPane().add(getList3(), getList3().getName());
		
		
		
	    } catch (Throwable Exc) {
		// user code begin {2}
		// user code end
		handleException(Exc);
	    }
	};
	return JFrameContentPane;
    }


    /**
     * Gestion des actions des boutons et des menus
     */

    
    /**
     * Handle an event on an object in this application.
     * @param event The event which occurred.
     * @return true if the event is handled, false if not
     **/

    public class ActionAdaptor1 implements ActionListener
    {
        public void actionPerformed(ActionEvent event)
        {
            Nouveau(event);
        }
    }
    
    ActionAdaptor1 actionAdaptor1;
    
    public void Nouveau(ActionEvent event) {
	JFileChooser fc = new JFileChooser();
	String ext[] = new String[1];
	ext[0] = "zip";
	ExampleFileFilter filter = new ExampleFileFilter(ext, "zip files");
	
	fc.setFileFilter(filter);
	fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
	fc.setDialogTitle("New zip archive");
	fc.setBounds(500,100,200,200);	
	int returnVal;
	if ((returnVal = fc.showDialog(getJFrame1(),"Open"))!=JFileChooser.CANCEL_OPTION )
	    if(fc.getSelectedFile().getAbsolutePath()!=null) {
		archiveCourante = new Operations(fc.getSelectedFile().getAbsolutePath(), Operations.ZIP);
		if (getList1().getItemCount()!=0)
		    getList1().removeAll();
		if (getList2().getItemCount()!=0)
		    getList2().removeAll();
		if (getList3().getItemCount()!=0)
		    getList3().removeAll();
	    } 
    }
                            

    public class ActionAdaptor2 implements ActionListener
    {
        public void actionPerformed(ActionEvent event)
        {
	    Ouvrir(event);
        }
    }
    
    ActionAdaptor2 actionAdaptor2;

    public void Ouvrir(ActionEvent event) {
	JFileChooser fc = new JFileChooser();
	String ext[] = new String[1];
	ext[0] = "zip";
	ExampleFileFilter filter = new ExampleFileFilter(ext, "zip files");
	
	fc.setFileFilter(filter);
	fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
	fc.setDialogTitle("Open zip archive");
	fc.setBounds(500,100,200,200);	
	int returnVal;
	if ((returnVal = fc.showDialog(getJFrame1(),"Open"))!=JFileChooser.CANCEL_OPTION )
	    if(fc.getSelectedFile().getAbsolutePath()!=null && fc.getSelectedFile().exists()) {
		archiveCourante = new Operations(fc.getSelectedFile().getAbsolutePath(), Operations.ZIP);
		
		archiveCourante.setInfoFiles((new CBunzip(archiveCourante.getArchiveName(),"")).getEntryInfo());
		Vector vect = new Vector();
		if (getList1().getItemCount()!=0)
		    getList1().removeAll();
		if (getList2().getItemCount()!=0)
		    getList2().removeAll();
		if (getList3().getItemCount()!=0)
		    getList3().removeAll();
		for(int i=0;i<archiveCourante.getInfoFiles().size();i++) {
		    vect.addElement(((EntryInfo)(archiveCourante.getInfoFiles().elementAt(i))).getName());
		    
		    getList1().add(((EntryInfo)(archiveCourante.getInfoFiles().elementAt(i))).getName());
		    getList2().add((new Long(((EntryInfo)(archiveCourante.getInfoFiles().elementAt(i))).getSize())).toString());
		    getList3().add((new Float(((EntryInfo)(archiveCourante.getInfoFiles().elementAt(i))).getRatio())).toString()+" %");
		}
		archiveCourante.setFilesVector(vect);
	    } else {
		System.out.println("Erreur : le fichier n'existe pas");
	    }
	
    }
    public class ActionAdaptor3 implements ActionListener
    {
        public void actionPerformed(ActionEvent event)
        {
               Ajouter(event);
        }
    }
    
    ActionAdaptor3 actionAdaptor3;

    public void Ajouter(ActionEvent event) {
	JFileChooser fc = new JFileChooser();
	
	fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
	fc.setDialogTitle("Add to archive : "+(new File(archiveCourante.getArchiveName())).getName());
	int returnVal;	
	returnVal = fc.showDialog(getJFrame1(),"Add");
	while(returnVal!=JFileChooser.CANCEL_OPTION) {
	    if(fc.getSelectedFile().getAbsolutePath()!=null) {
		archiveCourante.add(fc.getSelectedFile().getAbsolutePath());
		
		EntryStruct tab[] = new EntryStruct[archiveCourante.getFilesVector().size()];
		
		for (int i=0;i<tab.length;i++) {
		    tab[i] = new EntryStruct((new File((String)archiveCourante.getFilesVector().elementAt(i))).getName(), (new File((String)archiveCourante.getFilesVector().elementAt(i))).getAbsolutePath());
		}
		
		getList1().add(tab[tab.length-1].getAbsolutePath());
		cbzip = new CBzip(tab, archiveCourante.getArchiveName());
		cbzip.zipIt();
	    } 
	    returnVal = fc.showDialog(getJFrame1(),"Add");
	}
    }
    
    public class ActionAdaptor4 implements ActionListener
    {
        public void actionPerformed(ActionEvent event)
        {
           Extrait(event);
        }
    }
    
    ActionAdaptor4 actionAdaptor4;
    
    public void Extrait(ActionEvent event) {
	JFileChooser fc = new JFileChooser();

	fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
	fc.setDialogTitle("Extract to directory");
	int returnVal;	
	if ((returnVal = fc.showDialog(getJFrame1(),"Extract"))!=JFileChooser.CANCEL_OPTION && archiveCourante!=null)
	    if(fc.getSelectedFile().getAbsolutePath()!=null && fc.getSelectedFile().exists()) {
		cbunzip = new CBunzip(archiveCourante.getArchiveName(),fc.getSelectedFile().getAbsolutePath());
		cbunzip.extractFiles(archiveCourante.getArchiveName());
	    }
    }
    
    public class ActionAdaptor5 implements ActionListener
    {
        public void actionPerformed(ActionEvent event)
        {
	    Efface(event);
        }
    }
    
    ActionAdaptor5 actionAdaptor5;

    public void Efface(ActionEvent event) {
	archiveCourante.delete(getList1().getSelectedItem());
	getList1().remove(getList1().getSelectedItem());
	EntryStruct tab[] = new EntryStruct[archiveCourante.getFilesVector().size()];
		
	for (int i=0;i<tab.length;i++) {
	    tab[i] = new EntryStruct((new File((String)archiveCourante.getFilesVector().elementAt(i))).getName(), (new File((String)archiveCourante.getFilesVector().elementAt(i))).getAbsolutePath());
	}
	cbzip = new CBzip(tab, archiveCourante.getArchiveName());
	cbzip.zipIt();	
    }
	
    public class ActionAdaptor6 implements ActionListener
    {
        public void actionPerformed(ActionEvent event)
        {
	    Fermer(event);
        }
    }
    
    ActionAdaptor6 actionAdaptor6;

    public void Fermer (ActionEvent event) { 
        System.exit(0);
    }  
    


    /**
     * Called whenever the part throws an exception.
     * @param exception Throwable
     */

    private void handleException(Throwable exception) {
    }

    /**
     * Initializes connections
     */


    /**
     * main entrypoint - starts the part when it is run as an application
     * @param args String[]
     */

    public static void main(String[] args) {
	try {
	    ZipInterface aZipInterface;
	    aZipInterface = new ZipInterface();
	} catch (Throwable exception) {
	    System.err.println("Exception occurred in main() of Object");
	    exception.printStackTrace(System.out);
	}
    }

}
