import java.util.Vector;
/**
 * la classe qui gere les differents elements a zipper ou dezipper
 * @author C.Baeumler & B.Luttringer
 */


public class Operations {

    private Vector filesVector; /* le vecteur qui contient tous les fichiers  zipper 
				   ou bien l'archive a dzipper */

    private Vector infoFiles;
    
    private String extractDirectory; /* le repertoire dans lequel on doit extraire
					l'archive */

    private String archiveFileName; /* le nom de l'archive a creer */

    final static int ZIP = 0;
    final static int UNZIP = 1;
    
    /**
     * Construit un objet de type operations qui gere les fichiers a zipper ou bien le fichier a dezipper
     * Si type = ZIP, on zippe
     * Si type = UNZIP, on dezippe
     */
    public Operations(String archiveFilenameOrExtractDirectory, int type) {
	filesVector = new Vector();
	infoFiles = new Vector();
	if (type==ZIP)
	    archiveFileName = archiveFilenameOrExtractDirectory;
	else 
	    extractDirectory = archiveFilenameOrExtractDirectory;
    }
    
    /**
     * ouvre une nouvelle archive
     */
    public void openArchive(String zipFile) {
	filesVector.addElement(zipFile);
    }
    
    /**
     * ajoute un element a l'archive
     */
    public void add(String fileName) {
	filesVector.addElement(fileName);
    }
    
    /**
     * efface un element de l'archive
     */
    public void delete(String fileName) {
	filesVector.removeElement(fileName);
    }

    /**
     * retourne le vecteur des fichiers a zipper ou dezipper
     */
    public Vector getFilesVector() {
	return filesVector;
    }

    /**
     * place le vecteur des fichiers a zipper ou dezipper
     */
    public void setFilesVector(Vector vect) {
	filesVector = vect;
    }
    
    /**
     * retourne le nom de l'archive
     */
    public String getArchiveName() {
	return archiveFileName;
    }

    /**
     * retourne le vecteur des informations sur les fichiers
     */
    public Vector getInfoFiles() {
	return infoFiles;
    }

    /**
     * place le vecteur des informations sur les fichiers
     */
    public void setInfoFiles(Vector vect) {
	infoFiles = vect;
    }
}
    
