/**
 * Classe qui fournit des methodes pour manipuler les informations que 
 * contient generalement une entree zip
 * @author C.Baeumler & B.Luttringer
 */
public class EntryInfo {
    long size;
    float ratio;
    String name;
    
    /**
     * Constructeur de la classe
     * @param long size la taille d'une entree 
     * @param float ratio le rapport de compression
     * @param String name le nom de l'entree
     */ 
    public EntryInfo(long size, float ratio, String name) {
	this.size = size;
	this.ratio = ratio;
	this.name = name;
    }

    /**
     * retourne la taille de l'entree
     */
    public long getSize() {
	return size;
    }
    
    /**
     * retourne le rapport de compression
     */
    public float getRatio() {
	return ratio;
    }

    /**
     * retourne le nom de l'entree zip
     */
    public String getName() {
	return name;
    }

    /**
     * place la taille de l'archive
     * @param long size la taille
     */
    public void setSize(long size) {
	this.size = size;
    }

    /**
     * place le rapport de compression
     * @param float ratio le rapport
     */
    public void setRatio(float ratio) {
	this.ratio = ratio;
    }

    /**
     * place le nom de l'archive
     * @param String name le nom de l'entree
     */
    public void setName(String name) {
	this.name = name;
    }
}
