import java.util.*;
import java.io.*;
import EntryStruct;

/**
 * Classe Developper
 * Classe qui prend un tableau de fichiers en argument
 * et permet de renvoyer un vecteur de noms de fichiers
 * developpes suivant les repertoires auquels ils appartiennent
 * @see java.util.Vector
 * @author C.Baeumler & B.Luttringer
 */

public class Developper {
    
    Vector fileList;

    /**
     * Construit un objet de type Developper
     * qui permet d'expanser un repertoire dans un vecteur
     * @param tab le tableau des fichiers du repertoire courant
     */
    public Developper(EntryStruct tab[]) {
	fileList = new Vector();
	developp(tab, "");
    }
    
    /**
     * Procedure recursive qui permet d'expanser 
     * un tableau de fichiers contenant des repertoires
     * ceux ci sont developpes et stockes dans le vecteur des fichiers
     * fileList
     * @param tab le tableau des fichiers
     * @param length le nombre de fichiers contenus dans le repertoire
     * @param currentDirectory la chaine representant le repertoire actuel
     */
    
    public void developp(EntryStruct[] tab, String currentDirectory) {
	for (int i=0;i<tab.length;i++) {
	    File f = new File(tab[i].getAbsolutePath());
	    if (!f.isDirectory()) {
		fileList.addElement(new EntryStruct(tab[i].getEntryName(), tab[i].getAbsolutePath()));
			    }
	    else
		if (f.isDirectory()) {
		    fileList.addElement(new EntryStruct(currentDirectory+f.getName()+File.separator, f.getAbsolutePath()));
		    EntryStruct tabbis[] = new EntryStruct[f.list().length];
		    for(int j=0;j<tabbis.length;j++) {
			tabbis[j] = new EntryStruct(currentDirectory+f.getName()+File.separator+f.list()[j],/* (new File(currentDirectory+f.getName()+File.separator+f.list()[j])).getAbsolutePath()*/f.getAbsolutePath()+File.separator+f.list()[j]);
		    }
		    developp(tabbis, currentDirectory+f.getName()+File.separator);
		}
	}
    }
    
    /**
     * Accesseur du vecteur fileList,
     * contenant les repertoires expanses
     */
    
    public Vector getFileList() {
	return fileList;
    }
}

