import java.util.*;
import java.util.zip.*;
import java.io.*;
import Developper;
import EntryStruct;

//  Fichier:  CBzip.java 
//
/**
 *
 *  Cette classe permet la compression de fichier compatible
 *  a la norme pkzip <p>
 *
 *  Les differentes etapes de la compression sont : <br>
 *    1.  Creation des output stream   <br>
 *    2.  Ouverture des fichiers sources  <br>
 *    3.  Creation de l'entree zip  <br>
 *    4.  Remplissage de l'entree  <br>
 *    5.  Lecture des sources et ecriture des donnees dans l'output stream  <br>
 *    6.  Fermeture de l'entree zip et des autres streams ouverts  <br>
 *
 *  <p>
 *  Ligne de commande: <br>
 *  <pre> java CBzip nomFichierZip [nomsFichiersAZipper] </pre> <br>
 *
 *  <p>
 *  
 *  @author Baeumler Cyrille et Luttringer Benoit 
 *  @version 10 Decembre 98
 *
 *
 */
public class CBzip {

    String archiveFileName;
    Vector fileNamesArray;
    
    //-------------------------------------------------
    //  CONSTRUCTEURS
    //
    /**
     *
     *  Le constructeur sert a creer un nouvel objet CBzip
     *  base sur la ligne de commande : <br>
     *  <pre>  java CBzip nomFichierZip [nomsFichiersAZipper] </pre> </b> <br>
     *
     *  @param args - un tableau des fichiers entres avec la ligne de commande
     *
     */
    public CBzip(EntryStruct args[],String archiveFileName) {
	
//	EntryStruct tab[] = new EntryStruct[args.length-1];
	
	if (args.length == 0) {
	    System.exit(1);
	}
	
	this.archiveFileName = archiveFileName;
	
	// Cree le tableau des fichiers
	// si le nombre de fichiers (args.length)
	// est plus grand que 1
	//
	if (args.length >= 1) {
	    fileNamesArray = new Vector();
	    
//	    for (int j=0; j < tab.length; j++) 
//		tab[j] = args[j+1];
	    
	    Developper developper = new Developper(args);

	    fileNamesArray = developper.getFileList();
	    //	    for (int i=0;i<fileNamesArray.size();i++)
	    //		System.out.println(((EntryStruct)(fileNamesArray.elementAt(i))).getEntryName());
	}
    }

    //-------------------------------------------------
    //  METHODES
    //
    /**
     *  Lit les sources et ecrit les fichiers compresses. <br>
     *
     *  <p>
     *  Les differentes etapes de la compression sont : <br>
     *    1.  Creation des output stream   <br>
     *    2.  Ouverture des fichiers sources  <br>
     *    3.  Creation de l'entree zip  <br>
     *    4.  Remplissage de l'entree  <br>
     *    5.  Lecture des sources et ecriture des donnees dans l'output stream  <br>
     *    6.  Fermeture de l'entree zip et des autres streams ouverts  <br>
     */
    public void zipIt() {

	BufferedInputStream sourceStream;
	File theFile;
	FileInputStream fis;
      
	ZipOutputStream targetStream;
	FileOutputStream fos;
	ZipEntry theEntry;
      
	final int DATA_BLOCK_SIZE = 2048;
	int byteCount;
	byte data[];
      
	try {

	    // 1. Creation des OutputStream
	    //
	    System.out.println("Creation du ZIP: " + archiveFileName);
	    fos = new FileOutputStream(archiveFileName);
	    targetStream = new ZipOutputStream(fos);
	    targetStream.setMethod(ZipOutputStream.DEFLATED);
	    // on parcoure le tableau des fichiers 
	    
	    for (int i=0; i<fileNamesArray.size();i++) {
		theEntry = new ZipEntry(((EntryStruct)(fileNamesArray.elementAt(i))).getEntryName());
			  
		// distinction des sous repertoires
		//
		if (!theEntry.isDirectory()) {
		    fis = new FileInputStream(((EntryStruct)(fileNamesArray.elementAt(i))).getAbsolutePath());
		    sourceStream = new BufferedInputStream(fis);
	      
		    targetStream.putNextEntry(theEntry);
		    data = new byte[DATA_BLOCK_SIZE];
	      
		    while ( (byteCount = sourceStream.read(data, 0, DATA_BLOCK_SIZE)) != -1) {
			targetStream.write(data, 0, byteCount);
		    }
	      
		    targetStream.flush();
	      
		    //  fermeture de l'entry
		    //
		    targetStream.closeEntry();
	      
		    sourceStream.close();
		} else 
		    targetStream.putNextEntry(theEntry);
	    } // fin de la boucle
      
	    targetStream.close();
      
	}

	catch (IOException e)
	    {
		e.printStackTrace();
	    }

    }
 

    // Main de test du zip
    //
    public static void main(String args[])
    {
	EntryStruct tab[] = new EntryStruct[args.length-1];
	
	for (int i=0;i<tab.length;i++) {
	    tab[i] = new EntryStruct((new File(args[i+1])).getName(), (new File(args[i+1])).getAbsolutePath());
	    //tab[i].setEntryName((new File(args[i+1])).getName());
	    //tab[i].setAbsolutePath((new File(args[i+1])).getAbsolutePath());
	}
	
	CBzip cbzip = new CBzip(tab,args[0]);
	
	cbzip.zipIt();
    }

}
