import java.util.zip.*;
import java.io.*;
import java.util.*;


/**
 *
 *  Cette classe permet de dezipper un fichier zip.
 *
 *  <p>
 *  Les differentes etapes sont: <br>
 *    1. recuperer le zip input stream <br>
 *    2. recuperer les entrees du fichier zip <br>
 *    3. prepare le output stream non compresse <br>
 *    4. lire la source de donnees zippee et ecrire dans le output stream <br>
 *    5. fermer les flots source et cible
 *
 *  @author C.Baeumler, B.Luttringer
 *  @see java.util.zip.*
 *  @see java.io.*;
 *  @see java.util.*;
 *
 */

public class CBunzip {


    String zipFileName;
    
    String extractDirectory;
    
    final int DATA_BLOCK_SIZE = 2048;


    /**
     *  Le constructeur cree un nouvel objet Jkunzip qui permet de dezipper
     *  un fichier zip
     *  @param zipFileName le nom de l'archive zip.
     *  @param extractDirectory le repertoire d'extraction
     */
    public CBunzip(String zipFileName, String extractDirectory) {
      
	this.zipFileName = zipFileName;
	this.extractDirectory = extractDirectory;
	
    }
    


    /**
     *
     *  Extrait les fichiers du zip <br>
     *
     *  <p>
     *  Les differentes etapes sont : <br>
     *    1. recuperer le zip input stream <br>
     *    2. recuperer les entrees <br>
     *    3. preparer le output stream non compresse <br>
     *    4. lire la source zippe et ecrire dans le output stream non compresse <br>
     *    5. fermer la source et la cible <br>
     *
     *  @param theZipFileName le nom de l'archive zip
     *
     */
    public void extractFiles(String theZipFileName) {
	FileInputStream fis;
	ZipInputStream sourceZipStream;

	FileOutputStream fos;
	BufferedOutputStream targetStream;

	ZipEntry theEntry;

	try {
	    fis = new FileInputStream(theZipFileName);
	    sourceZipStream = new ZipInputStream(fis);
	
  
	    while ( (theEntry = sourceZipStream.getNextEntry()) != null ) {
		if (theEntry.isDirectory()) {
		    (new File(extractDirectory+File.separator+theEntry.getName())).mkdir();
		    System.out.println("Creating directory "+extractDirectory+File.separator+theEntry.getName());
		} else {
		    fos = new FileOutputStream(extractDirectory+File.separator+theEntry.getName());
		    targetStream = new BufferedOutputStream(fos, DATA_BLOCK_SIZE);
	      
		    System.out.println("\tUnzipping: " + theEntry);
	      
		    int byteCount;
		    byte data[] = new byte[DATA_BLOCK_SIZE];
	      
		    while ( (byteCount = sourceZipStream.read(data, 0, DATA_BLOCK_SIZE)) != -1) 
			targetStream.write(data, 0, byteCount);
	      
		    targetStream.flush();
		    targetStream.close();
		}
	    }
	    sourceZipStream.close();
      
	} catch (IOException exc) {
	    exc.printStackTrace();
	}

    }


    public Vector getEntryInfo() {

	FileInputStream fis;
	ZipInputStream sourceZipStream;
	
	Vector entryInfo = new Vector();
	ZipEntry theEntry;

	try {
	    fis = new FileInputStream(zipFileName);
	    sourceZipStream = new ZipInputStream(fis);
	    
	    while ( (theEntry = sourceZipStream.getNextEntry()) != null ) {
		if (!theEntry.isDirectory())
		    entryInfo.addElement(new EntryInfo(theEntry.getCompressedSize(),(float)theEntry.getCompressedSize()/(float)theEntry.getSize()*100f,theEntry.getName()));
	    }
	    sourceZipStream.close();
	    
	} catch (IOException exc) {
	    exc.printStackTrace();
	}
	
	return entryInfo;
    }
		    
    public static void main(String args[]) {
	CBunzip cbunzip = new CBunzip(args[0],args[1]);
    }
		    
}
