package como.util;


import java.util.Hashtable;

/**
* This class keeps a Hashtable (int)-(int). If get(a) is called,
* it is blocked until (a) is contained in the Hashtable
* If put is called, the argument is passed to all get()s that are waiting
* ONLY ONE GET FOR EACH ID MAY BE RUNNING AT THE SAME TIME
*/
public class Semaphore {

	private Hashtable ht = new Hashtable();
	private Hashtable wt = new Hashtable();

	public synchronized int get(int id) {
	Integer Id = new Integer(id);
		if (wt.containsKey(Id)) {
			Debug.msg(99,"Semaphor.get() Process already waiting");
			return -1;
		}
		wt.put(Id,Id);
		while( !ht.containsKey(Id)) {
			try {
				wait();
				if (!ht.containsKey(Id)) notify();	
			} catch( InterruptedException e ) {
			}
		}
		int r =  ((Integer)ht.get(Id)).intValue();
		wt.remove(Id);
		ht.remove(Id);
		return r;
	}

	public synchronized void put( int id, int data ) {
		ht.put(new Integer(id),new Integer(data));
		if (wt.containsKey(new Integer(id))) notify();
	}
}
