/**
 * CubbyHole based on the CubbyHole from the progguide.
 *
 */

package como.util;


/**
 * Use this to communicate between processes.
 * Put in an Object and read it from the other side!
 *
 * As long as nobody put()'s an Object into it, the
 * get() will block!
 */

public class CubbyHole {
	private Object obj;
	private boolean available = false;

	/**
	 * gets the Object from the CubbyHole.
	 * @return the Object.
	 */
	public synchronized Object get() {
		while( available == false ) {
			try {
				wait();
			} catch( InterruptedException e ) {
			}
		}
		available = false;
		return obj;
	}

	/**
	 * put an Object in the CubbyHole.
	 * @param o the Object.
	 */
	public synchronized void put( Object o ) {
		obj = o;
		available = true;
		notify();
	}
}
