/*
* @(#)UserPanel.java    1.0 95/11/09 Ulrich Gall & Jan Kautz
*
* Copyright (c) 1996 Ulrich Gall & Jan Kautz 
* uhgall@cip.informatik.uni-erlangen.de
* Hofmannstr. 48, D-91052 Erlangen, Germany, Fax: +49-9131-201358
*
* Permission to use, copy, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please contact us for  further copyright 
* and licensing information.
*
* WE MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WE SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/
package como.sys;


import como.awt.*;
import como.util.*;

import java.util.*;
import java.awt.*;

/**
 * This class displays and edits information about users. 
 * All fields are displayed. Standard fields are displayed neatly.
 */
 
public class UserPanel extends Panel
{
	boolean edit;
	User user;
	Button updatebutton;
	Hashtable comps;
	String okbuttontext;
	Image map;
	Panel addcomppanel;

	/**
	* Constructs a new Panel from the specified user
	*/
	public UserPanel(User u,String okbutton)
	{
		super();
		edit = (okbutton.length() != 0);
		okbuttontext = okbutton;
		setUser(u);
	}
	public UserPanel(User u,String okbutton,Image mapimg)
	{
		super();
		edit = (okbutton.length() != 0);
		okbuttontext = okbutton;
		map = mapimg;
		setUser(u);
	}
	public UserPanel() {
		super();
		edit = false;
		setUser(null);
		}
	public void setUser(User u)
	{
		user = u;
		if (user != null) {
		comps = new Hashtable();
		removeAll();
		setLayout(new BorderLayout());
		addcomppanel = new Panel();
		addcomppanel.setLayout(new VertLayout(VertLayout.STRETCH));	
		add("North",addcomppanel);

		addComp("ID",User.ID,false);
		if (!user.containsKey(User.NAME)) user.put(User.NAME,"Unknown");
		addComp("Name",User.NAME,edit);
		addComp("Nickname",User.NICK,false);
		addComp("Host address",User.ADDRESS,false);
		addComp("Color",User.COLOR,edit);
		if (!user.containsKey(User.COMMENT)) user.put(User.COMMENT,"Unknown");
		addComp("Comment",User.COMMENT,edit);
		
		if ((map != null) && user.containsKey(User.LOCATION)) {
			ImageClick ic = new ImageClick(map);
			if (user.get(User.LOCATION) instanceof Point) ic.setPos((Point)user.get(User.LOCATION));
			ic.setEditable(edit);
			add("Center",ic);
			comps.put(ic,User.LOCATION);
		}
		
		if (edit) {
			updatebutton = new Button(okbuttontext);
			add("South",updatebutton);
		}
		}
	}
	public void setEditable(boolean b) {
	edit = b;
		}
	public void addComp(String desc,Object key,boolean e) {
		if (user.containsKey(key)) {
			Object o = user.get(key);	
			if (o instanceof String) {
				Panel p = new Panel();
				p.setLayout(new BorderLayout());
				p.add("West",new Label(desc+": "));
				TextField tf = new TextField((String)o);
				tf.setEditable(e);
				comps.put(tf,key);
				p.add("Center",tf);
				addcomppanel.add(p);
			}
			else if (o instanceof Color) {
				if (e) {
					addcomppanel.add(new Label(desc));
					ColorSelector cs = new ColorSelector((Color)o);
					comps.put(cs,key);
					addcomppanel.add(cs);
				}
				else {
					Panel p = new Panel();
					p.setLayout(new BorderLayout());
					p.add("West",new Label(desc+": "));
					Canvas c = new Canvas();
					c.setBackground((Color)o);
					p.add("Center",c);
					addcomppanel.add(p);
				}
			}
		}
	}
	public User getUser() {
		if (edit) {
		Enumeration e = comps.keys(); // enumerates the components...
		while(e.hasMoreElements()) {
			Component c = (Component)e.nextElement();
			Object key = comps.get(c);
			if (c instanceof TextField) user.put(key,((TextField)c).getText());
			if (c instanceof ColorSelector) user.put(key,((ColorSelector)c).getColor());
			}
			}
		return user;
		}
	public boolean action(Event evt, Object arg) {
		if (edit) {
			if (evt.target == updatebutton) {
				getParent().postEvent(new Event(this,Event.ACTION_EVENT,getUser()));		
				return true;
			}
			Object key = comps.get(evt.target);
			user.put(key,evt.arg);
		}
		return true;
	}

}
