/*
* @(#)User.java    1.0 95/11/09 Ulrich Gall & Jan Kautz
*
* Copyright (c) 1996 Ulrich Gall & Jan Kautz 
* uhgall@cip.informatik.uni-erlangen.de
* Hofmannstr. 48, D-91052 Erlangen, Germany, Fax: +49-9131-201358
*
* Permission to use, copy, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please contact us for  further copyright 
* and licensing information.
*
* WE MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WE SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/

package como.sys;

import como.io.*;
import java.util.*;
import java.io.IOException;

/**
 * This class stores information about users. You can put anything in it;
 * As keys, either use sufficiently large Integers or any other class; the safest
 * way is to use instances of one of your own classes as keys.
 * 
 * A number of standard keys are declared.
 */
 
public class User extends Hashtable implements Saveable
{
	public static Integer ID=new Integer(0);
	public static Integer NAME=new Integer(1);
	public static Integer FACE=new Integer(2);
	public static Integer ADDRESS=new Integer(3);
	public static Integer EMAIL=new Integer(4);
	public static Integer NOTES=new Integer(5);
	public static Integer PRIMHOST=new Integer(6);
	public static Integer SOCKET=new Integer(7);
	public static Integer NICK=new Integer(8);
	public static Integer COLOR=new Integer(9);
	public static Integer COMOUSER=new Integer(10);
	public static Integer COMMENT=new Integer(11);
	public static Integer LOCATION=new Integer(12);
	public static Integer SCORE=new Integer(13);

	/**
	 * Contructor for User.
	 */
	public User() {
	}

	/**
	 * Contructor for User.
	 * @param id the user's ID.
	 * @param name the user's name.
	 */
	public User(int id,String name)
	{
		put(ID,new Integer(id));
		put(NAME,name);
	}

	/**
	 * Return the user's ID.
	 * @return ID
	 */
	public int getID() {
		if (containsKey(ID)) return ((Integer)get(ID)).intValue();
		else return -1;
	}

	/**
	 * Return the user's name.
	 * @return the name.
	 */
	public String getName() {
		if (containsKey(NAME)) return (String)get(NAME);
		else return "Unknown User #"+getID();
	}

	/**
	 * Saves this Object to the ObjectOutputStream s.
	 * @param s the ObjectOutputStream.
	 */
	public void save(ObjectOutputStream s) throws IOException{
		Hashtable h = new Hashtable();
		Enumeration e = keys();
		while (e.hasMoreElements()) {
			Object k = e.nextElement();
			h.put(k,get(k));
		}

		s.writeObject(h);
	}

	/**
	 * Load this Object from the ObjectInputStream s.
	 * @param s the ObjectOutputStream.
	 */
	public void load(ObjectInputStream s) throws IOException{
		clear();
		Hashtable h = (Hashtable)s.readObject();
		Enumeration e = h.keys();
		while (e.hasMoreElements()) {
			Object k = e.nextElement();
			put(k,h.get(k));
		}
	}
}
