/*
* @(#)Msg.java    1.0 95/11/09 Ulrich Gall & Jan Kautz
*
* Copyright (c) 1996 Ulrich Gall & Jan Kautz 
* uhgall@cip.informatik.uni-erlangen.de
* Hofmannstr. 48, D-91052 Erlangen, Germany, Fax: +49-9131-201358
*
* Permission to use, copy, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please contact us for  further copyright 
* and licensing information.
*
* WE MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WE SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/

package como.sys;

/**
 * This is used for sending messages over the net. A Msg can include an object
 * that implements Saveable.
 * Some classes are inherently supported (String, Integer, Dictionary)
 * 
 * Just like an Event, a Msg has a type (integer). For your own messages
 * you can pick any types > 10000. We strongly recommend increasing the
 * numbers the further you go down the Object hierarchy.
 * 
 * For messages, type should be >0. Right now, answers are implemented as
 * negative types. The answer is  the inverse of the question.
 */

public class Msg extends Object {
	public static final int NOT_ALLOWED = 0;
	public static final int NO_CONNECTION = 1;
	public static final int OK = 2;
	public static final int WHO_AM_I = 3;
	public static final int WHO_ELSE = 4;
	public static final int COM_CLASS = 6;
	public static final int CONNECT_TO_EXISTING_COM = 7;
	public static final int INVITATION = 8;
	public static final int MAKE_SOCKET = 9;
	public static final int LOAD_CLASS = 10;
	public static final int LINE_DROPPED = 11;
	public static final int NO_DATA = 12;
	public static final int PRIVATE_DATA = 13;
	public static final int ARE_YOU_THERE = 14;
	public static final int CLASS_CODE = 15;
	public static final int PING = 16;
	public static final int GET_USER_INFO = 17;
	public static final int ASK_MASTER = 18;
	public static final int UPCOMING_USER = 19;
	public static final int NEW_TOPIC = 20;
	public static final int NEW_USER_INFO = 21;
	public static final int NEW_MASTER = 22;
	public static final int KICK_USER = 23;

	// Comlet

	public static final int USER_LEFT = 101;
	public static final int ADD_USER = 102;

	// WindowComlet

	public static final int WINDOW_MOVED = 103;

	// Chat
	public static final int CHAT_DIALOG_STRING = 500;
	public static final int CHAT_PERSONAL_STRING = 501;

	// x > 10000 can be used by Clients without registering them here.
	// Just make sure you're not using a MSG ID from a parent class.

	public int from;
	public int to;
	public Object arg;  // can be everything!
	public int type;

	/**
	* Message Priority: 0 = highest Priority
	*/
	public int priority;

	/**
	 * Contructor for a message.
	 * @param typ the type of the Message (e.g. NEW_USER_INFO)
	 * @param f the sender's ID
	 * @param t the ID you want to send the message to.
	 * @param o the Object you want to send (must implement Saveable or be support java.lang-Object)
	 */
	public Msg( int typ, int f, int t, Object o ) {
		type = typ;
		from = f;
		to = t;
		arg = o;
	}

	/**
	 * Contructor for a message.
	 * @param typ the type of the Message (e.g. NEW_USER_INFO)
	 * @param f the sender's ID
	 * @param t the ID you want to send the message to.
	 * @param p the message's priority (0 highest).
	 * @param o the Object you want to send (must implement Saveable or
	 *  must be supported by como.io.ObjectXXXStream).
	 */
	public Msg( int typ, int f, int t, int p,Object c ) {
		type = typ;
		from = f;
		to = t;
		arg = c;
		priority = p;
	}

	/**
	 * Contructor for a message. The sender's ID is not set,
	 * but is usually set by the ComObj automatically.
	 * @param typ the type of the Message (e.g. NEW_USER_INFO)
	 * @param t the ID you want to send the message to.
	 * @param o the Object you want to send (must implement Saveable or
	 *  must be supported by como.io.ObjectXXXStream).
	 */
  	public Msg(int type, int to, Object arg) {
		this.to = to;
		this.type = type;
		this.arg = arg;
  	}

	/**
	 * Contructor for a message.
	 * @param typ the type of the Message (e.g. NEW_USER_INFO)
	 * @param o the Object you want to send (must implement Saveable or
	 *  must be supported by como.io.ObjectXXXStream).
	 */
	public Msg( int typ, Object c ) {
		this( typ, 0, 0, c );
	}

	/**
	 * Contructor for a message.
	 * @param typ the type of the Message (e.g. NEW_USER_INFO)
	 */
	public Msg( int typ ) {
		this( typ, 0, 0, null );
	}

	/**
	 * Checks if the current msg is an answer-message.
	 * @return true if the message is an answer.
	 */
	public boolean isAnswer() {
		if( type < 0 )
		return true;
		else
		return false;
	}

	/**
	 * Make the msg to an answer or non-answer-message.
	 * @param isanswer set to true, if you want to make an answer.
	 */
	public void setAnswer( boolean isanswer ) {
		if( isanswer )
		type = -Math.abs( type );
		else
		type = Math.abs( type );
	}

	/**
	 * Returns a String object representing this message.
	 * @return the String.
	 */
	public String toString()
	{
		if( arg != null )
			return( "Msg(): type: " + type + " from: " + from +
			" to: " + to + " cont: " + arg.toString() );
		else
			return( "Msg(): type: " + type + " from: " + from +
			" to: " + to + " arg: empty " );
	}
}
