package como.irc;

import java.util.*;
import java.lang.*;
import java.io.IOException;
import como.io.*;

public class IrcChan implements Saveable {
	String channel; // mit como234252_
	String commletname;
	String topic;

	public IrcChan() {
		channel = commletname = topic = "Unknown";
	}

	public IrcChan( String ch, String co, String to  ) {
		channel = ch;
		commletname = co;
		topic = to;
	}
	
	public IrcChan( String comname, String t ) {
		// Create a new unused channel-name.
		// TODO: 
		// attention two users may creat the same channel
		// if they click at the very same time!!!
		// But is this really realistic???
		// Even if yes, it should work quand meme.
		
		channel = "como"+(new Date()).getTime();
		commletname = comname;

		topic = t; 
	}

	public String ircName() {
	   return channel+"~"+commletname;
	}
	
	public String toString() {
	   return channel+"~"+commletname+"~"+topic;
	}

	public void save( ObjectOutputStream o ) throws IOException {
		o.writeString( channel );
		o.writeString( commletname );
		o.writeString( topic );
	}

	public void load( ObjectInputStream i ) throws IOException {
		channel     = i.readString();
		commletname = i.readString();
		topic       = i.readString();
	}
	
	public void fromString( String s ) {
		StringTokenizer st = new StringTokenizer( s, "~" );
		
		try {
			channel = st.nextToken();
			commletname = st.nextToken();
			topic = st.nextToken();
		} catch( NoSuchElementException e ) {
			// means no topic was set!
			// -> keep cool here.
			topic = "Unkown";
		}
	}
}
