package como.irc;

import java.io.*;

/**
 * Converts not-liked IRC-Characters to characters that an IRC-Daemon
 * understands.
 */
public class IRCOutputStream extends OutputStream {
    /**
     * The actual input stream.
     */
    protected OutputStream out;

    /**
     * Creates an output stream filter, filtering out and replacing escapechars
     * @param in	the input stream
     */
    public IRCOutputStream(OutputStream out) {
	this.out= out;
    }

    /**
     * Writes a byte. Will block until the byte is actually
     * written.
     * @param b the byte
     * @exception IOException If an I/O error has occurred.
     */
    public void write(int b) throws IOException {
	
	if (b == (int)'\r') { out.write('\\'); out.write('r'); }
	else if (b == (int)'\n') { out.write('\\'); out.write('n'); }
	else if (b == (int)'\0') { out.write('\\'); out.write('0'); }
	else if (b == (int)'\\') { out.write('\\'); out.write('\\'); }
	else out.write(b);
    }

    /**
     * Writes an array of bytes. Will block until the bytes
     * are actually written.
     * @param b	the data to be written
     * @exception IOException If an I/O error has occurred.
     */
    public void write(byte b[]) throws IOException {
	write(b, 0, b.length);
    }

    /**
     * Writes a sub array of bytes. To be efficient it should
     * be overridden in a subclass. 
     * @param b	the data to be written
     * @param off	the start offset in the data
     * @param len	the number of bytes that are written
     * @exception IOException If an I/O error has occurred.
     */
    public void write(byte b[], int off, int len) throws IOException {
	for (int i = 0 ; i < len ; i++) {
	    write(b[off + i]);
	}
    }

    /**
     * Flushes the stream. This will write any buffered
     * output bytes.
     * @exception IOException If an I/O error has occurred.
     */
    public void flush() throws IOException {
	out.flush();
    }

    /**
     * Closes the stream. This method must be called
     * to release any resources associated with the
     * stream.
     * @exception IOException If an I/O error has occurred.
     */
    public void close() throws IOException {
	flush();
	out.close();
    }
}
