package como.irc;

import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.io.*;
import java.util.Date;
import java.util.Hashtable;

import como.awt.*;
import como.commlet.*;
import como.util.*;
import como.sys.*;

public class ComoPageClient extends Applet implements ComoIRCFrontEnd {

	static int LOG_LINES = 4;
	static int MIN_NAME_LENGTH = 2;
	static int IRC_PORT = 6667;
	static int IRC_MAX_NICK_LENGTH = 9;

	static final String VERSION = "V0.01";
	static final String LOGOUT_BUTTON = "IMPORTANT: Please click here to LOG OUT";

	static int EVENT_INVITATION_ACCEPTED = 15015;
	static int EVENT_INVITATION_REJECTED = 15016;

	UserPanel loginuserpanel;
	Button logoutButton;
	User ego = null;
	
	ServerIRC server = null;

	String channel;
	String commlet;
	String topic;
	boolean autologout = false;
	boolean invitable = false;
	String name = null;
	int ircport = IRC_PORT;
	IrcChan ircchan = null;
	int commletsrunning = 0;

	String[][] params = {
		{"IRCPort","integer","Port to connect to"},
		{"Channel","String","If set, that channel will be joined if it exists"},
		{"Commlet","String","If set, the given channel will be opened with "+
					"this commlet if it doesn't exist"},
		{"Name","String", "If set, user gets name automatically. "+
				"This name begin with the given String. "+
				"Otherwise, user has to log in."},
		{"Invitable","String","If set, user may be invited by others"},
		{"Autologout","String","If set, user will be logged out when last Commlet Session ends."},
		{"Topic","String","Which topic to set if opening channel"}};

	public void init()	{

	channel = getParameter("Channel");
	commlet = getParameter("Commlet");
	topic = getParameter("Topic");
	ircchan = new IrcChan(channel,commlet,topic);
	name = getParameter("Name");
	String s = getParameter("IRCPort");
	try {
		ircport = (new Integer(s.trim())).intValue();
		}
	catch (Exception e) { ircport = IRC_PORT; }
	invitable = (getParameter("Invitable") != null);
	autologout = (getParameter("Autologout") != null);
	}

 public String[][] getParameterInfo() {
	return params;
	}
	public String getAppletInfo() {
	return "ComoPageClient "+VERSION+" (c) Jan Kautz & Ulrich Gall Tel. +49-9131-201329";
	}
	/** 
	* Called after user logged in
	*/
	public void showLoggedIn() {
	removeAll();
	}
	/**
	* Displays a dialog that will let the user login in.
	*/
	public void showLogin() {
		removeAll();
		setLayout(new BorderLayout());
		add("North",new Label("Please fill in the following information to log in:"));
		ego = new User(0,"");
		ego.put(ego.COMMENT,"");
		loginuserpanel = new UserPanel(ego,"Click here to log in!");
		add("Center",loginuserpanel);
		ego = null;
		paintAll(getGraphics());
	}

	private void clearStatus() {
		if (ego != null)
		showStatus(ego.get(User.NAME).toString() + "'s Como Session");
		else
		showStatus("");
	}
	
	public void logout() {
		// Ask the user if he wants to log out
		server.logout();
		showLogin();
	}
	public void stop() {	
	}
	public void start() {
	if (ego == null) {
		if (name == null) {
			showLogin();
		}
		else {
		// automatically select a name
		
			ego = new User();
			int a = (new Date()).hashCode();
			if (a < 0) a = -a;
			ego.put(ego.NAME,name + a);
			try {
				server = new ServerIRC(ego,getDocumentBase().getHost(),ircport,this);
			} catch ( IOException e ) {
				removeAll();
				paintAll(getGraphics());
				return;
			}
		}
		if (channel != null) {
			server.joinChannel(ircchan);
			commletsrunning++;
		}
	}
	}

    public boolean handleEvent(Event evt) {
	     if (super.handleEvent(evt)) return true;
	     if (evt.id == EVENT_INVITATION_REJECTED) {
		     ((Frame)evt.target).dispose();
		     return true;
	     }
 	  if (evt.id == EVENT_INVITATION_ACCEPTED) {
		log("Invitation to channel "+evt.arg.toString());
	  	server.joinChannel((IrcChan)evt.arg);
		commletsrunning++;
	    	((Frame)evt.target).dispose();
	    	return true;
  	}
	return false;
	}
	
	public boolean action(Event evt,Object what) {
		if (evt.target == logoutButton) {
			logout();
		}
		else if (evt.target == loginuserpanel) {
			ego = loginuserpanel.getUser();
			if (ego.get(ego.NAME).toString().trim().length()  > MIN_NAME_LENGTH) {
				clearStatus();
			ego.put(ego.COLOR, new Color(ego.hashCode()));
				removeAll();
				add(new Label("Logging in, please wait..."));
				paintAll(getGraphics());
				layout();
				paintAll(getGraphics());
				try {
					server = new ServerIRC(ego,getDocumentBase().getHost(),IRC_PORT,this);
				} catch( Exception e ) {
					new SmartFrame( "No connection to server, try again later!" );
				}
				showLoggedIn();
				return true;}
		}
		return false;		
	}


// To implement ComoIRCFrontEnd

	public void noConnection() {
	logout();
	}
	public void handleInvitation(User u,IrcChan chan) {
	if (invitable) {
		SmartFrame f = new SmartFrame(this,
		 	"Yes, accept",new Event(this,EVENT_INVITATION_ACCEPTED,chan),
			"No, reject",new Event(this,EVENT_INVITATION_REJECTED,null));
		f.setTitle("Invitation received...");
		Panel p = new Panel();
		p.setLayout(new VertLayout(VertLayout.CENTER));
		String name = u.get(u.NAME).toString();
		String comment = u.get(u.COMMENT).toString();
		p.add(new Label("Invitation from "+name+"("+comment+")"));
		p.add(new Label("Would you like to join a "+chan.commletname+ " Session?"));
		p.add(new Label("Topic : "+chan.topic));
		f.add("North",p);
		f.pack();
		f.show();
		}
		}
	public void log(String s) {
	showStatus(s);
	}
	public void addUser(String nick) {
	}
	public void userLeft(String nick) {
	}
	public Applet getApplet() {
	return this;
	}
        public void leftChannel(IrcChan chan) {
	commletsrunning--;
	if ((commletsrunning == 0) && (autologout)) {
		server.logout();	
		ego = null;
		}
	}
}
