package como.irc;

import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.io.*;
import java.util.*;

import como.awt.*;
import como.commlet.*;
import como.util.*;
import como.io.*;
import como.sys.*;

public class ComoIRCClient extends Applet {
	ComoIRCClientFrame comoframe;
	static int IRC_PORT = 6667;
	static final String VERSION = "V1.00";

	String[][] params = {
		{"IRCPort","int","IRC Server port to connect to"},
		{"HelpPage","http-address","A http-address of the help-page"}
	};

	public void init()	{
		int ircport;
		URL helppage;
		String s;

		s = getParameter("IRCPort"); 
		try { 
			ircport = (new Integer(s.trim())).intValue(); 
		} 
		catch (Exception e) {
			ircport = IRC_PORT; 
		}

		s = getParameter( "HelpPage" ); 
		if( s == null || !s.startsWith( "http://" ) )
			s = "http://www4.informatik.uni-erlangen.de/IMMD-IV/Projects/como/doc/como-irc-help.html";

		try {
			helppage = new URL( s );
		} catch( MalformedURLException e ) {
			helppage = null;
			Debug.msg( 9, "ComoIRCClient.init(): no helppage" );
		}

		comoframe = new ComoIRCClientFrame( this, ircport, helppage );
	}

	// start and stop methods not needed, we have our own frame!
	public void start() {
		return;
	}
	public void stop() {	
		return;
	}

	public String getAppletInfo() {
		return "ComoIRCClient "+VERSION+" (c) Jan Kautz & Ulrich Gall Tel. +49-9131-201329";
	}
	public String[][] getParameterInfo() {
		return params;
	}
}

class ComoIRCClientFrame extends Frame implements ComoIRCFrontEnd {
	static int COMMLET_LINES = 7;
	static int USER_LINES = 8;
	static int CHANNEL_LINES = 6;
	static int MIN_NAME_LENGTH = 2;
	static int IRC_MAX_NICK_LENGTH = 9;
	static int IMGSIZE = 96;

	static final int COMMLET_NAME = 0;
	static final int COMMLET_ICON_NAME = 1;
	static final int COMMLET_DESCRIPTION = 2;

	static final String USER_CHOICE_ALL = "All Available Users";
	static final String USER_CHOICE_USER = "Users matching pattern";
	static final String USER_CHOICE_CHANNEL = "Users on channel";

	static int EVENT_INVITATION_ACCEPTED = 15015;
	static int EVENT_INVITATION_REJECTED = 15016;

	List userlist;
	User[] users;
	Button userupdate;
	Choice userchoice;
	TextField userpattern;
	Checkbox usercomoonly;
	
	Button commletstartbutton;
	Panel commletpanel;
	TextField commletdescriptionfield;
	ImageButton commletimagebuttons[];
	String commletnames[][];
	
	List channellist;
	IrcChan[] channels;
	Hashtable channelHT;
	Button channelupdate;
	TextField channelpattern;
	Checkbox channelcomoonly;
	Button channeljoinbutton;
	Button channelviewbutton;
	Button channelinvitebutton;

	MenuItem miquit;
	MenuItem mihelp;

	URL helppage;
	int ircport;

	Panel userpanel;
	Hashtable userHT;
	Panel channelpanel;

	TextField logTF;	
	TextField nickTF;
	TextField nameTF;
	UserPanel loginuserpanel;
	SmartFrame loginNameTooShort;
	SmartFrame loginClickMap;
	User ego;
	
	ServerIRC server = null;
	Applet applet;

	Image map;

	public ComoIRCClientFrame( Applet applet, int ircport, URL helppage )	{
		super( "ComoClient Applet"  );

		this.helppage = helppage;
		this.ircport = ircport;
		this.applet = applet;

		try {
			map = applet.getImage(new URL(applet.getDocumentBase(),"worldmap"));
		}
		catch (Exception e) {
			map = null;
		}

		makeMenu();
		showLogin();
		pack();
		show();
	}
	

	/**
	 * Displays a dialog that will let the user login in.
	 */
	public void showLogin() {
		removeAll();

		setLayout(new BorderLayout());
		Panel p = new Panel();
		p.setLayout(new VertLayout(VertLayout.STRETCH));
		p.add(new Label("Please fill in the following information to log in:"));
		p.add(new Label("On the map, click at your current location"));
		add("North",p);
		ego = new User(0,"");
		ego.put(ego.COMMENT,"");
		ego.put(ego.LOCATION,new Integer(0)); // that way we will not set a default position
		loginuserpanel = new UserPanel(ego,"Click here to log in!",map);
		add("Center",loginuserpanel);

		ego = null;

		paintAll(getGraphics());
	}

	public void makeMenu() {
		MenuBar menubar = new MenuBar();
		Menu menfile = new Menu("File");
		Menu menhelp = new Menu("Help");

		miquit = new MenuItem("Quit");
		mihelp = new MenuItem("How to use Como");

		menfile.add( miquit );
		menhelp.add( mihelp );

		menubar.add( menfile );
		menubar.add( menhelp );

		// this will be the help menu!
		menubar.setHelpMenu( menhelp );

		setMenuBar( menubar );
	}
	
	private void showLists()	{
		createUserPanel();
		createCommletPanel();
		createChannelPanel(); 
		
		setLayout(new VertLayout(VertLayout.STRETCH));
		
		removeAll();

		add(userpanel);
		add(commletpanel);
		add(channelpanel);

		logTF = new TextField();
		logTF.setEditable(false);
		Panel p = new Panel();
		p.setLayout(new BorderLayout());
		p.add("West",new Label("Status:"));
		p.add("Center",logTF);
		add(p);

		pack();
		layout();
		paintAll(getGraphics());
	}

	private void createUserPanel() {
		userpanel = new Panel();
		userpanel.setLayout(new BorderLayout());
		userlist = new List(USER_LINES,true);
		userpanel.add("Center",userlist);
		Panel p = new Panel();
		p.setLayout(new BorderLayout());
		userchoice=new Choice();
		userchoice.addItem(USER_CHOICE_ALL);
		userchoice.addItem(USER_CHOICE_USER);
		userchoice.addItem(USER_CHOICE_CHANNEL);
		p.add("West",userchoice);
		userpattern = new TextField("*");
		p.add("Center",userpattern);
		usercomoonly = new Checkbox("Como Users Only");
		usercomoonly.setState(true);
//		p.add(usercomoonly);
		userupdate = new Button("Update");
		p.add("East",userupdate);
		userpanel.add("North",p);
		updateuserlist();
	}
	private void createChannelPanel() {
		channelpanel = new Panel();
		channelpanel.setLayout(new BorderLayout());
		channellist = new List(CHANNEL_LINES,false);
		channelpanel.add("Center",channellist);
		Panel p = new Panel();
		p.setLayout(new BorderLayout());
		p.add("West",new Label("Available channels matching "));
		channelpattern = new TextField("*",10);
		p.add("Center",channelpattern);
		channelcomoonly = new Checkbox("Como channels Only");
		channelcomoonly.setState(true);
//		p.add(channelcomoonly);
		channelupdate = new Button("Update");
		p.add("East",channelupdate);
		channelpanel.add("North",p);
		channeljoinbutton = new Button ("Join this channel");
		channeljoinbutton.disable();
		channelviewbutton = new Button ("See who is on this channel");
		channelviewbutton.disable();
		channelinvitebutton = new Button("Invite selected Users");
		channelinvitebutton.disable();
		Panel q = new Panel();
		q.add(channelviewbutton);
		q.add(channeljoinbutton);
		q.add(channelinvitebutton);
		channelpanel.add("South",q);
		updatechannellist();
	}

	private synchronized void updatechannellist() {
		showStatus("Updating Channel List...");
		channellist.delItems(0,channellist.countItems()-1);
		channels = server.getChannels(channelpattern.getText(),channelcomoonly.getState());
		channelHT = new Hashtable();
		String s = null;
		for (int i = 0;i<channels.length;i++)
		{
			IrcChan c = channels[i];
			s = c.commletname + " session with topic '" + c.topic+"'";
			channellist.addItem(s);
			channelHT.put(s,new Integer(i));
		}
		channelinvitebutton.disable();
		channeljoinbutton.disable();
		channelviewbutton.disable();
		clearStatus();
	}
	
	private synchronized void updateuserlist() {
		showStatus("Updating User List...");

		userHT = new Hashtable();
		userlist.delItems(0,userlist.countItems()-1);

		String pattern = userpattern.getText().trim();
		boolean comoonly = usercomoonly.getState();

		if (userchoice.getSelectedItem() == USER_CHOICE_ALL)
			pattern = "*";

		users = server.getUsers(pattern,comoonly);
		for (int i = 0;i<users.length;i++)
		{
			User u = users[i];
			StringBuffer s = new StringBuffer();

			if (u.containsKey(u.NAME)) s.append(u.get(u.NAME).toString());
			if (u.containsKey(u.NICK)) s.append(" ("+u.get(u.NICK).toString()+")");

/*			if ((u.containsKey(u.COMOUSER)) && (u.get(u.COMOUSER) == Boolean.TRUE))
			s.append(" using Como as ");
			else
			s.append(" using IRC as "); */

			if (u.containsKey(u.COMMENT)) s.append(" ("+u.get(u.COMMENT).toString()+")"); 

			userlist.addItem(s.toString());
			userHT.put(s.toString(),new Integer(i));
		}

		clearStatus();
		if (commletstartbutton != null) commletstartbutton.disable();
	}

	private void clearStatus() {
		if (ego != null)
			showStatus(ego.get(User.NAME).toString() + "'s Como Session");
		else
			showStatus("");
	}

	private void createCommletPanel() {
		Vector lines;

		Panel commletbuttonpanel = new Panel();
		commletpanel = new Panel();

		commletpanel.setLayout(new BorderLayout());
		commletbuttonpanel.setLayout( new FlowLayout() );

		try {
			URL url = new URL(applet.getDocumentBase(),server.PATH_COMMLET_LIST);
			lines = StreamLine.loadLines( new DataInputStream(url.openStream()) );
		} catch( Exception e ) {
			commletpanel.add("North",new Label("Sorry, could not load available commlets!"));
			commletpanel.add("South",new Label("Please try again later."));
			return;
		}

		int nrlines = lines.size();
		commletnames = new String[nrlines][3];  // CommletName, PicName, Description
		commletimagebuttons = new ImageButton[nrlines]; // ImageButtons for them

		for( int i = 0; i < nrlines; i++ ) {
			String line = (String)lines.elementAt(i);
			int first = line.indexOf( ':' );
			int second = line.indexOf( ':', first+1 );

			commletnames[i][COMMLET_NAME] = line.substring( 0, first-1 ).trim();
			commletnames[i][COMMLET_ICON_NAME] = line.substring( first+2, second-1 ).trim();
			commletnames[i][COMMLET_DESCRIPTION] = line.substring( second+2 ).trim();

			try {
				URL url = new URL( applet.getDocumentBase(), server.PATH_COMMLET_ICONS+commletnames[i][1] );
				Image image = applet.getImage( url );
				commletimagebuttons[i] = new ImageButton( image, image, IMGSIZE, IMGSIZE );
			}
			catch( Exception e ) {
				commletimagebuttons[i] = new ImageButton( IMGSIZE, IMGSIZE, commletnames[i][0] );
			}

			commletbuttonpanel.add( commletimagebuttons[i] );
		}

		commletdescriptionfield = new TextField();
		commletdescriptionfield.setEditable( false );

		commletpanel.add("North",new Label("Available Commlets"));
		commletpanel.add("Center", commletbuttonpanel );
		commletpanel.add("South", commletdescriptionfield );
	}

	public void logout() {
		// Ask the user if he wants to log out?

		if( server != null )
			server.logout();
		hide();
		dispose();

		// don't show the Login anymore.. (we did first)
		// showLogin();
	}

	public boolean action(Event evt,Object what) {
		if (evt.target == miquit) {
			logout();
			return true;
		}
		else if (evt.target == mihelp) {
			// At the moment just show it instead of the current page
			// This causes no problem, because we don't do anything in
			// the stop()-Method.

			if( helppage != null )
				applet.getAppletContext().showDocument( helppage, "_blank" );
		}
		else if (evt.target == loginuserpanel) {
				ego = loginuserpanel.getUser();

				if (ego.get(ego.LOCATION) instanceof Integer) {
					if ((loginClickMap == null) || (!loginClickMap.isVisible())) {
						loginClickMap = new SmartFrame("Please click on the map where you are from.");
						}
					return true;
					}
				if (ego.get(ego.NAME).toString().trim().length()  <= MIN_NAME_LENGTH) {
					if ((loginNameTooShort == null) || (!loginNameTooShort.isVisible())) {
						loginNameTooShort = new SmartFrame("Your name must be at least "+
									(MIN_NAME_LENGTH+1)+" characters long.");
						}
					return true;
					}
				clearStatus();
				ego.put(ego.COLOR, new Color(ego.hashCode()));
				removeAll();

				setLayout( new BorderLayout() );
				add( "North", new Label("Logging in, please wait...") );

				layout();
				paintAll(getGraphics());

				if (loginNameTooShort != null) {
					loginNameTooShort.dispose();
					loginNameTooShort = null;
				}
				if (loginClickMap != null) {
					loginClickMap.dispose();
					loginClickMap = null;
				}

				try {
					server = new ServerIRC(ego,applet.getDocumentBase().getHost(),ircport,this);
				} catch( IOException e ) {
					new SmartFrame( "Couldn't connect to server, try again later" );
					noConnection();
					return true;
				}
				showLists();
				return true;
		}
		else if (ego != null) {

			for( int i = 0; i < commletnames.length; i++ )
			{
				if (evt.target == commletimagebuttons[i]) {
					// clicked on a commlet-button

					String commletname = commletnames[i][COMMLET_NAME];

					int[] selints = userlist.getSelectedIndexes();
					if( selints.length > 0 )
					{
						User[] u = new User[selints.length];

						for( int j=0; j < selints.length; j++ )
							u[j] = users[selints[j]];

						showStatus("Starting Commlet " + commletname + " with " + selints.length + " users"); 				
						server.startCommunication(commletname,u,commletname + " started on " + (new Date()).toString());
					}
					else {
						new SmartFrame( "Select some users before starting a Commlet!" );
					}

					clearStatus();
					return true;
				}
			}

			if (evt.target == userlist) {
				// double clicked on a user -> show info about that user
				// (ask server)
				showStatus("Retrieving Information about "+evt.arg.toString());
				//	User u = server.getUser(users[((Integer)userHT.get(evt.arg)).intValue()]);
				User u = users[((Integer)userHT.get(evt.arg)).intValue()];
				
				Frame f = new SmartFrame();
				f.setLayout(new VertLayout(VertLayout.STRETCH));
				f.add(new UserPanel(u,""));
				f.pack();
				f.setTitle( "User Information" );
				f.show();
				clearStatus();
				return true;
			}

			if ((evt.target == userupdate) || (evt.target==userpattern) || (evt.target == userchoice))
			{
				updateuserlist();
			}

			if ((evt.target == channelupdate)|| (evt.target==channelpattern))
			{
				updatechannellist();
			}

			if ((evt.target == channellist) || (evt.target == channelviewbutton)) 
			{
				IrcChan chan = null;
				if (evt.target == channelviewbutton) {
					if (channellist.getSelectedIndex() != -1) 
						chan = channels[channellist.getSelectedIndex()];
				}
				else
					if (evt.arg != null) chan = channels[((Integer)channelHT.get(evt.arg)).intValue()];
				String s = "";	
				if (chan != null) {
					s = "#"+chan.channel+"~"+chan.commletname;
				showStatus("Updating User List to display users on channel "+s);
				userpattern.setText(s);
				userchoice.select(2);
				updateuserlist();
						}
				else {
					//MODAL
				}
			}

			if (evt.target == channeljoinbutton)
			{
				showStatus("Joining Channel "+channellist.getSelectedItem());
				server.joinChannel(channels[channellist.getSelectedIndex()]);
			}

			if (evt.target == channelinvitebutton)
			{
					int[] selints = userlist.getSelectedIndexes();
					showStatus("Inviting "+selints.length+" users to channel "+channellist.getSelectedItem());
					for (int i=0;i<selints.length;i++) 
						server.sendInvitation(channels[channellist.getSelectedIndex()],users[selints[i]]);
			}
		}
		return false;		
	}

	public void handleInvitation(User u,IrcChan chan) {
		SmartFrame f = new SmartFrame(this,
		 	"Yes, accept",new Event(this,EVENT_INVITATION_ACCEPTED,chan),
			"No, reject",new Event(this,EVENT_INVITATION_REJECTED,null));
		f.setTitle("Invitation received...");
		Panel p = new Panel();
		p.setLayout(new VertLayout(VertLayout.CENTER));
		String name = u.get(u.NAME).toString();
		String comment = u.get(u.COMMENT).toString();
		if( comment.length() > 0 )
			p.add(new Label("Invitation from "+name+" ("+comment+")"));
		else
			p.add(new Label("Invitation from "+name));
		p.add(new Label("Would you like to join a "+chan.commletname+ " Session?"));
		p.add(new Label("Topic : "+chan.topic));
		f.add("North",p);
		f.pack();
		f.show();
	}		

	public boolean handleEvent(Event evt) {

		if (evt.id == Event.MOUSE_ENTER )
		{
			if( commletnames == null ) return false;

			// look if the mouse moved over a commlet-imagebutton 
			for( int i = 0; i < commletnames.length; i++ )
			{
				if (evt.target == commletimagebuttons[i]) {
					commletdescriptionfield.setText( commletnames[i][COMMLET_NAME]+" : "+
						commletnames[i][COMMLET_DESCRIPTION] );

					return true;
				}
			}

			return false;
		}

		if (evt.id == Event.WINDOW_DESTROY ) {
			logout();
			return true;
		}

		if (evt.id == EVENT_INVITATION_REJECTED) {
			((Frame)evt.target).dispose();
			return true;
		}

		if (evt.id == EVENT_INVITATION_ACCEPTED) {
			server.joinChannel((IrcChan)evt.arg);
			((Frame)evt.target).dispose();
			return true;
		}

		if (evt.target == channellist) {
			if (channellist.getSelectedIndex() == -1) {
				channelviewbutton.disable();
				channeljoinbutton.disable();	
			}
			else {
				channelviewbutton.enable();
				channeljoinbutton.enable();	
			}
		}

		if ((evt.target == channellist) || (evt.target == userlist)) {
			if ((channellist.getSelectedIndex() != -1) 
				&& (userlist.getSelectedIndexes().length >0) 
				&& (server.isUserOnChannel(ego,channels[channellist.getSelectedIndex()]))) {
				channelinvitebutton.enable();
			}
			else {
				channelinvitebutton.disable();
			}
		}

		return super.handleEvent(evt);
	}

	public void log(String s) {
		if( logTF != null )
		{
			logTF.setText( s );
			logTF.select( 0, 0 );
		}
	}

	public void showStatus( String s ) {
		log( s );
		// applet.showStatus( s );
	}

	public synchronized void addUser(String nick) {
		if (userlist != null) updateuserlist();
	}

	public synchronized void userLeft(String nick) {
		updateuserlist();
	}

	public void noConnection() {
		showLogin();
	}

	public Applet getApplet() {
		return applet;
	}

	public void leftChannel(IrcChan chan) {
		return;
	}
}
