/**
 * StreamLine.java  (c) 1996 Jan Kautz & Ulrich Gall
 *
 *
 */

package como.io;

import como.util.*;
import java.io.*;
import java.util.Vector;

/**
 * loads all lines from a DataInputStream.
 */
public class StreamLine {
	public StreamLine() {
	}

	/**
	 * loads all lines from a DataInputStream
	 *
	 * @param dis a DataInputStream from where to load
	 * @return a Vector with all lines (Strings)
	 */
	static public Vector loadLines( DataInputStream dis ) {
		Vector lines = new Vector();

		try {
			String l = dis.readLine();
			while ((l != null) && (l.length() > 0)) {
				lines.addElement( l );
				l = dis.readLine();
			}
		}
		catch (Exception e) {
			Debug.msg( 30, "Error loading Line from Stream: "+e.toString() ) ;
			return null;
		}

		return lines;
	}
}
