/**
 *
 * Saveable.java     (c) 1996 Ulrich Gall & Jan Kautz
 *
 */

package como.io;

import java.io.IOException;
import como.io.*;

/**
 * Objects that may be saved/loaded from/to disk/network
 * should implement this interface. Then they can be
 * converted using the ObjectXXXStream!
 *
 */
public interface Saveable {
	/**
	 * This method is called when the Object is loaded!
	 * It gets instantiated and then load(i) will be called.
	 * @param i ObjectInputStream from where you can read
	 *  your saved data.
	 */
	public void load(ObjectInputStream i) throws IOException;

	/**
	 * This method is called when the Object is saved!
	 * save(o) will be called. You have to write any
	 * necessary data to it (which will be loaded afterwards
	 * by load() from an ObjectInputStream).
	 * @param o ObjectOutputStream where you have to write
	 *  your data.
	 */
	public void save(ObjectOutputStream o) throws IOException;
}
	
