/**
 *
 * ObjectOutputStream.java    (c) 1996 Ulrich Gall & Jan Kautz
 *
 */

package como.io;

import como.util.Debug;
import java.io.*;
import java.awt.*;
import java.util.*;
import como.io.*;
import como.sys.*;
import como.irc.*;
import como.commlet.*;

/*
 * This Stream can write any Objects to a given stream, that
 * implement Saveable. It also supports various java-classes
 * (see ObjectInputStream).
 *
 */

public class ObjectOutputStream extends DataOutputStream {

	public static byte SAVEABLE = 1;
	public static byte INTEGER = 2;
	public static byte STRING = 3;
	public static byte COLOR = 4;
	public static byte HASHTABLE = 5;
	public static byte BOOLEAN = 6;	
	public static byte FONT = 7;
	public static byte DIMENSION = 8;
	public static byte POINT = 9;
	public static byte INTARRAY = 10;
	public static byte BYTEARRAY = 11;

	public ObjectOutputStream(OutputStream out) {
		super(out);
		}

	/**
	 * writes a String to the stream. You don't have to care
	 * about the length!
	 * @param s the String you want to save.
	 */
	public void writeString(String s) throws IOException { // TODO Do some basic Huffman encoding?
		int l = s.length();
		writeInt(l);
		byte[] b = new byte[l];
		s.getBytes(0,l,b,0);
		write(b,0,l);
	}                               

	// TODO: writeNumber, schreibt automatisch den krzesten datentyp

	/**
	 * writes a Object to the stream. This Object must implement
	 * Saveable, or it must be one of the supported classes (see
	 * ObjectInputStream)
	 * @param o the Object you want to save.
	 */
	public void writeObject(Object o) throws IOException {
		if (o instanceof Saveable) {
			writeByte(SAVEABLE);
			writeString(o.getClass().getName());
			((Saveable)o).save(this);
		}
		else if (o instanceof Boolean) {
			writeByte(BOOLEAN);
			writeBoolean(((Boolean)o).booleanValue());
		}
		else if (o instanceof Integer) {
			writeByte(INTEGER);
			writeInt(((Integer)o).intValue());
		}
		else if (o instanceof String) {
			writeByte(STRING);
			writeString((String)o);
		}
		else if (o instanceof Font) {
			writeByte(FONT);
			Font f = (Font)o;
			writeString(f.getName());
			writeInt(f.getStyle());
			writeInt(f.getSize());
		}
		else if (o instanceof Color) {
			writeByte(COLOR);
			writeByte(((Color)o).getRed());
			writeByte(((Color)o).getGreen());
			writeByte(((Color)o).getBlue());
		}
		else if (o instanceof Point) {
			writeByte(POINT);
			writeInt(((Point)o).x);
			writeInt(((Point)o).y);
			}
		else if (o instanceof Dimension) {
			writeByte(DIMENSION);
			writeInt(((Dimension)o).width);
			writeInt(((Dimension)o).height);
			}
		else if (o instanceof int[]) {
			int[] ar = (int[])o;
			writeByte(INTARRAY);
			writeInt(ar.length);
			int i;
			for (i=0;i<ar.length;i++) {
				writeInt(ar[i]);
			}
		}
		else if (o instanceof byte[]) {
			byte[] ar = (byte[])o;
			writeByte(BYTEARRAY);
			writeInt(ar.length);
			int i;
			for (i=0;i<ar.length;i++) {
				writeByte(ar[i]);
			}
		}
		else if (o instanceof Hashtable) {
			writeByte(HASHTABLE);
			Hashtable h = (Hashtable)o;
			writeInt(h.size());
			Enumeration e = h.keys();
			while (e.hasMoreElements()) {
				Object k = e.nextElement();
				writeObject(k);
				writeObject(h.get(k));
			}
		}
	}
}
