package como.io;

/**
* ObjectInputStream.java   
*
* (c) 1996 Jan Kautz & Ulrich Gall
*
*/

import java.io.*;
import java.util.*;
import java.awt.*;
import como.io.*;
import como.irc.*;
import como.sys.*;
import como.commlet.*;
import como.commlet.draw.*;
import como.commlet.nicnacnoe.*;
import como.commlet.scheduler.*;
import como.util.*;

/**
* An ObjectInputStream is used to write Objects to a Stream.
* It can load every Object that implements Saveable and
* which was saved with the ObjectOutputStream!
* You can even recursively load/save Objects. I.e. an object
* may call writeObject( my_object ) in it's save()-method!
*
*/
public class ObjectInputStream extends DataInputStream {

	public ObjectInputStream(InputStream in) {
		super(in);
	}

	/**
	 * Reads a String from the ObjectInputStream. You don't have
	 * to draw attention to the length. It will be automatically
	 * correct!
	 * @return the String that was loaded
	 */
	public String readString() throws IOException { // TODO Do some basic Huffman encoding?
		int l = readInt();
		byte[] b = new byte[l];
		read(b,0,l);
		return new String(b,0,0,l);
	}                               

	// TODO: readNumber, writes automatically the shortest datatype

	/**
	 * Reads an Object from the ObjectInputStream. It reads
	 * every Object that implements Saveable. And some other
	 * basic Classes like Hashtable, Integer, byte[], int[],
	 * Boolean, Point, Dimension.
	 * @return the Object that was loaded
	 */
	public Object readObject() throws IOException {
		byte t = readByte();

		if (t == ObjectOutputStream.SAVEABLE) {
			String cn = readString();
			Saveable o = null;

			// TODO: as soon as loading classes in an applet works, forget this
			// for now, we have to do that instead (since no class-loader is
			// allowed by netscape, which lets you instantiate Objects by name!):

			if (cn.equals("como.commlet.draw.GOText")) o = new GOText();
			else if (cn.equals("como.commlet.draw.GOGroup")) o = new GOGroup();
			else if (cn.equals("como.commlet.draw.GOPolygon")) o = new GOPolygon();
			else if (cn.equals("como.commlet.draw.GOOval")) o = new GOOval();
			else if (cn.equals("como.commlet.draw.GORect")) o = new GORect();
			else if (cn.equals("como.commlet.draw.GOImage")) o = new GOImage();
			else if (cn.equals("como.commlet.draw.GOLine")) o = new GOLine();
			else if (cn.equals("como.commlet.nicnacnoe.Piece")) o = new como.commlet.nicnacnoe.Piece();
			else if (cn.equals("como.commlet.scheduler.UserSchedule")) o = new como.commlet.scheduler.UserSchedule();
			else if (cn.equals("como.irc.IrcChan")) o = new IrcChan();
			else if (cn.equals("como.sys.User")) o = (Saveable)new User();
	
			if (o != null) o.load(this) ;
				else Debug.msg(10,"ObjectInputStream: Cannot instantiate Object of class "+cn);
			return o;
		}
		else if (t == ObjectOutputStream.INTEGER) {
			return (new Integer(readInt()));
		}	
		else if (t == ObjectOutputStream.BOOLEAN) {
			return (new Boolean(readBoolean()));
		}	
		else if (t == ObjectOutputStream.FONT) {
			String name = readString();
			int style = readInt();
			int size = readInt();
			return new Font(name,style,size);
			}
		else if (t == ObjectOutputStream.STRING) {
			return readString();
		}
		else if (t == ObjectOutputStream.POINT) {
			int x = readInt();
			int y = readInt();
			return (new Point(x,y));
		}
		else if (t == ObjectOutputStream.DIMENSION) {
			int w = readInt();
			int h = readInt();
			return (new Dimension(w,h));
		}
		else if (t == ObjectOutputStream.BYTEARRAY) {
			int l = readInt();
			byte[] ar = new byte[l];
			int i;
			for (i=0;i<l;i++) {
				ar[i] = readByte();
			}
			return ar;
		}
		else if (t == ObjectOutputStream.INTARRAY) {
			int l = readInt();
			int[] ar = new int[l];
			int i;
			for (i=0;i<l;i++) {
				ar[i] = readInt();
			}
			return ar;
		}
		else if (t == ObjectOutputStream.COLOR) {
			int r = readByte();
			int g = readByte();
			int b = readByte();
			return (new Color(r,g,b));
		}
		else if (t == ObjectOutputStream.HASHTABLE) {
			int size = readInt();
			Hashtable h = new Hashtable(size);
			int i;
			for (i=0;i<size;i++) {
				h.put(readObject(),readObject());
			}
			return h;
		}
			Debug.msg(100,"ObjectInputStream: Cannot load Object of type #"+t);
		return null;
	}
}
