package como.commlet.webcheckers;

import java.awt.*;

public class Case extends Canvas{

  //MEMBRES
private final static int SIDE = 40;
public final static int BLACK = 1; // type de case
public final static int WHITE = -1;// type de case
private final static Color BLACK_COLOR = Color.black;
private final static Color WHITE_COLOR = Color.white;
private final static Color HIGH_COLOR = Color.yellow;
public final static String CASE = "CASE"; // String car il faut un heritier de Object
private int type;
private int x;
private int y;
private Pion My_Pion = null;


  //CONCTRUCTEUR
  
public Case(int type,int x,int y){

  this.type = type;
  if (type == BLACK) setBackground(BLACK_COLOR);    
  else setBackground(WHITE_COLOR);
  this.x=x;
  this.y=y;
}
  
public Case(Pion P,int x,int y){
  //Si le constructeur place un pion => c'est une case blanche!
  type = WHITE;;
  setBackground(WHITE_COLOR);
  My_Pion = P;
  My_Pion.Set_Position(x,y);
  this.x=x;
  this.y=y;
}

  //METHODES

public void Set_Pion(Pion P){
  My_Pion = P;
  My_Pion.Set_Position(x,y);
}

public Pion Get_Pion(){
  return My_Pion;
}

public void Set_Empty(){
  My_Pion = null;
}

public boolean Is_Empty(){
  return (My_Pion == null);
}

public boolean Is_Ennemy(Case C){

  if ((!Is_Empty()) && (!(C.Is_Empty()))) return My_Pion.Ennemy(C.Get_Pion());
  return false;
}

public void Make_King(Pion P){
  // le pion de la case devient une dame
  Dame D = new Dame(P.Player);
  D.Set_Position(x,y);
  P.Player.Remove_Pion();
  P.Player.Add_Pion();
  My_Pion = D;
}

public void Eaten(){
  // le pion de la case s'est fait bouffer
  if (My_Pion != null){
    My_Pion.Player.Remove_Pion();
    My_Pion = null;
  }
}

public int X(){
  return x;
}

public int Y(){
  return y;
}

  //METHODES DU CANVAS
  
public Dimension minimumSize(){
  return new Dimension(SIDE,SIDE);
}

public Dimension preferredSize(){
  return minimumSize();
}

public void paint(Graphics g){
  g.clearRect(0,0,SIDE,SIDE);
  if (My_Pion != null) My_Pion.Display(g,SIDE);
}

public void HighLight(boolean high){
  if (type == WHITE) {
    if (high) setBackground(HIGH_COLOR);
    else setBackground(WHITE_COLOR);
    repaint();
  }
}

public boolean handleEvent(Event e){
  // je recupere l'event mouse down
  // et je le rebalance en precisant
  // que c'est moi qui ai ete touche'

  if (e.id == Event.MOUSE_DOWN){
    Event Ev = new Event(this, Event.ACTION_EVENT, CASE);
    Ev.modifiers = e.modifiers;
    deliverEvent(Ev);
  }
  return super.handleEvent(e);
}

}

