
package como.commlet.userlist;

import java.awt.*;
import java.util.*;
import como.util.*;
import como.awt.*;
import como.sys.*;
import como.commlet.*;

public class UserList extends WindowCommlet

{

UserPanel userpanel = null;
Button kickbutton = null;
List userlist = null;
Hashtable users = null; // String listentry -> Integer id
int idshown = -1;
Image map;

	public UserList()
	{
	}

	public String getCommletName()
	{
		return("UserList");
	}

	public String getCommletInfo()
	{
		return("UserList, V 1.0, Jan Kautz & Ulrich Gall");
	}

	public void init()
	{
		super.init();
		map = com.loadImage("worldmap");
		if (map == null) new SmartFrame("UserList was unable to load a map image");
		userpanel = null ;
		userlist = new List();
		setLayout( new BorderLayout() );

		kickbutton = new Button( "Kick User" );
		if( !com.iAmMaster() )
			kickbutton.disable();

		add( "West", userlist );
		// add( "South", kickbutton );

		idshown = com.getMyID();
		updateList();
		updateUserPanel();
		resize(400,400);	
	}
	
	public boolean action(Event evt,Object arg) {
		if (evt.arg instanceof User)
			{ 
			User user = (User)evt.arg;
			if (user.containsKey(User.ID))
				{
				if (((Integer)user.get(User.ID)).intValue() == com.getMyID())
					com.setLocalUser(user);
				}
			return true;
			}	
		return false;
		}

	public boolean handleEvent(Event evt) {
		if (super.handleEvent(evt)) return true;

		if (evt.target == userlist) {
			String sel = userlist.getSelectedItem();

			if (sel != null) {
				idshown = ((Integer)users.get(sel)).intValue();
			}

			updateUserPanel();
			return true;
		}

		if( evt.target == kickbutton ) {
			// TODO: do sth.
		}

		return false;
	}

	private void updateList() {
		// Known Bug under Win 95: userlist.clear(); does not work correct!

		userlist.delItems( 0, userlist.countItems()-1 );

		Vector getusers = com.getUsers();
		users = new Hashtable();
		Enumeration userenum = getusers.elements();

		while (userenum.hasMoreElements()) {
			String name;
			User u = (User)userenum.nextElement();
			name = u.getName()+" (#"+u.getID()+")";
			userlist.addItem(name);
			if (u.getID() == idshown) userlist.select(userlist.countItems()-1);
			users.put(name,u.get(u.ID));
		}
	}

	private void updateUserPanel() {
		if (idshown >= 0) 
		{
			String ok;
			if (idshown == com.getMyID()) ok = "Send Update" ; else ok = "";

			// remove the old user-panel!
			if( userpanel != null )
				remove( userpanel );

			userpanel = new UserPanel(com.getUser(idshown),ok,map);
			add("Center",userpanel);
			paintAll(getGraphics());
		}
		else {
			userpanel = null;
		}

	}

	public boolean handleMsg(Msg msg)
	{
/* Thought it is not a good idea to let every UserList kick people.
		if (msg.type == Msg.NEW_MASTER) {
			if( !com.iAmMaster() )
				kickbutton.disable();
			else
				kickbutton.enable();
		}
*/
		if (msg.type == Msg.NEW_USER_INFO) {
			if (idshown == ((User)msg.arg).getID()) updateUserPanel();
			updateList();
		}
		else if (msg.type == Msg.USER_LEFT) {
			if (idshown == ((Integer)msg.arg).intValue()) {
				idshown = com.getMyID();
				updateUserPanel();
			}
			updateList();
		}
		else if (msg.type == Msg.ADD_USER) {
			updateList();
		}
		return false; // since this "handling" does not really count
	}
}
