package como.commlet.superchat;

import java.awt.*;
import java.applet.AudioClip;
import java.util.Hashtable;
import java.io.*;
import java.util.*;

import como.sys.*;
import como.util.*;
import como.awt.*;
import como.io.*;
import como.commlet.*;
import como.commlet.userlist.*;

public class SuperChat extends WindowCommlet
{
	public static final int MAX_USERS = 5;

	public static final int MSG_PLAY_SOUND = 10051;
	public static final int MSG_SUPERCHAT_EVENT = 10052;
	public static final int MSG_NEW_FACE = 10053;
	public static final int MSG_PRIVATE_CHAT = 10054;

	int numberOfUsers = 0;
	TextArea dialog;
	TextField input;
	FacePanel facepanel;
	ScrollPanel scrollpanel;
	Hashtable usernames;
	Button kickbutton;
	Button whisperbutton;
	Button audiobuttons[];
	AudioClip sounds[];
	AudioClip useraddedclip = null;
	AudioClip userleftclip = null;
	AudioClip lineclip = null;
	String soundnames[][] = {
		{ "Laugh", "laugh.au", "laughs." },
		// just in case the SuperChat.sounds doesn't work :-)
	};


	public SuperChat() {
		usernames = new Hashtable();

		return;
	}

	public String getCommletName()
	{
		return "Super Chat Commlet, V1.0, (c) Jan Kautz & Ulrich Gall.";
	}

	public String getCommletInfo()
	{
		return
		"(c) 1996 Ulrich Gall & Jan Kautz\n"+
		"\n";
	}

	public void init()
	{
		super.init();

		setLayout(new BorderLayout());

		// NORTH
		Panel p = new Panel();
		p.setLayout(new BorderLayout());
		p.add("West",new Label("Current Topic: "));
		p.add("Center",getTopicTextField());
		add("North",p);

		// CENTER
		Panel centerpanel = new Panel();
		centerpanel.setLayout( new BorderLayout() );

		dialog = new TextArea();
		dialog.setEditable(false);

		centerpanel.add( "Center", dialog );

		Panel insidepanel = new Panel();
		insidepanel.setLayout( new BorderLayout() );

		input = new TextField();
		insidepanel.add( "North", input );

		// sound...
		print("Loading soundfile...");

		loadSoundFile();
		audiobuttons = new Button[soundnames.length];

		Panel actionpanel = new Panel();
		actionpanel.setLayout( new FlowLayout() );
		for( int i = 0; i < soundnames.length; i++ ) {
			actionpanel.add( audiobuttons[i] = new Button( soundnames[i][0] ) );
		}

		insidepanel.add( "South", actionpanel );
		centerpanel.add( "South", insidepanel );
		add( "Center", centerpanel );

		// WEST
		Panel westpanel = new Panel();
		Panel kickpanel = new Panel();
		westpanel.setLayout( new BorderLayout( 10, 10 ) );
		kickpanel.setLayout( new VertLayout( VertLayout.STRETCH ) );

		facepanel = new FacePanel( com, this );
		scrollpanel = new ScrollPanel( (Component)facepanel, (float)0.1 );

		kickpanel.add( kickbutton = new Button( "Kick user(s)" ) );
		if( !com.iAmMaster() ) kickbutton.disable();
		kickpanel.add( whisperbutton = new Button( "Whisper to user(s)" ) );

		westpanel.add( "Center", scrollpanel );
		westpanel.add( "South", kickpanel );

		add( "West", westpanel );
		pack();

		print(getCommletName());
		print(getCommletInfo());       

		print("Ready, waiting for messages...");
	}

	public void loadSoundFile() {
		InputStream is = com.openInputStream( "SuperChat.sounds" );
		Vector lines;

		if( is == null )
		{
			sounds = new AudioClip[1];
			return;	// could not find file
		}

		lines = StreamLine.loadLines( new DataInputStream( is ) );
		int nrlines = lines.size() - 3;
		soundnames = new String[nrlines][3];
		sounds = new AudioClip[nrlines];

		for( int i = 0; i < nrlines; i++ ) {
			String line = (String)lines.elementAt( i+3 );
			int first = line.indexOf( ':' );
			int second = line.indexOf( ':', first+1 );
			
			soundnames[i][0] = line.substring( 0, first-1 ).trim();
			soundnames[i][1] = line.substring( first+2, second-1 ).trim();
			soundnames[i][2] = line.substring( second+2 ).trim();

			// means has still to be loaded!
			sounds[i] = null;
		}

		useraddedclip = com.loadAudioClip( ((String)lines.elementAt(0)).trim() );
		userleftclip = com.loadAudioClip( ((String)lines.elementAt(1)).trim() );
		lineclip = com.loadAudioClip( ((String)lines.elementAt(2)).trim() );
	}

	public void loadSound( int i )
	{
		sounds[i] = com.loadAudioClip( soundnames[i][1] );
	}

	public void addUser( int TheNewUser )
	{
		if( useraddedclip != null )
			useraddedclip.play();
		print(com.getUserName(TheNewUser) + " has joined the conversation.");
		usernames.put(new Integer(TheNewUser),com.getUserName(TheNewUser));

		facepanel.addUser( TheNewUser );
		scrollpanel.redo();

		numberOfUsers++;
	}

	public void userLeft( int RankWhoLeft )
	{
		if( userleftclip != null )
			userleftclip.play();
		print(com.getUserName(RankWhoLeft) + " has left the conversation.");

		facepanel.removeUser( RankWhoLeft );
		scrollpanel.redo();

		numberOfUsers--;
	}

	public boolean isUserAdmitted( User who ) {

		// If you uncomment this, only MAX_USERS
		// will be permitted to join this channel!
		// if( numberOfUsers >= MAX_USERS ) return false;

		return true;
	}

	public void stop()
	{
		facepanel.stop();

		com.sendToOthers(new Msg(Msg.CHAT_DIALOG_STRING,"bye bye..."));
		super.stop();
	}

	void print(String s)
	{
		int width = dialog.size().width;
		Font font = dialog.getFont();
		FontMetrics fm = null;

		if( font != null ) fm = dialog.getFontMetrics(font);

		if( fm != null ) {
			width -= fm.stringWidth( "MMMM" );	// just like that.

			StringTokenizer st = new StringTokenizer( s, " " );
			StringBuffer line = new StringBuffer();
	
			while( st.hasMoreTokens() ) {
				String next = st.nextToken();

				if( fm.stringWidth( line.toString()+next+" " ) < width )
					line.append( " "+next );
				else
				{
					dialog.insertText(line+"\n",dialog.getText().length());
					line = new StringBuffer( "   "+next );
				}
			}
			dialog.insertText(line+"\n",dialog.getText().length());
		}
		else
			dialog.insertText(s+"\n",dialog.getText().length());

		// move the textfield down!
		int l = dialog.getText().length()-2;
		dialog.select( l, l );
	}

	public boolean handleMsg(Msg msg)
	{
		if( super.handleMsg(msg) ) return true;
		if( facepanel.handleMsg( msg ) ) return true;

		if( msg.arg == null ) msg.arg = "";

		if( msg.type == Msg.NEW_MASTER ) {
			if( com.iAmMaster() ) kickbutton.enable();
			else kickbutton.disable();

			// let it fall through
			return false;
		}

		if (msg.type == Msg.NEW_USER_INFO)
		{
			String newname = com.getUserName(msg.from);
			User newuser = com.getUser(msg.from);
			if (!usernames.get(new Integer(msg.from)).equals(newname))
			{
				print(usernames.get(new Integer(msg.from)) + " is now known as "+newname);
				usernames.put( new Integer( msg.from ), newname );
			}

			facepanel.newUserInfo( msg.from );

			// well perhaps some other people are interested!
			return false;
		}

		if (msg.type == MSG_PLAY_SOUND)
		{
			int nr = ((Integer)msg.arg).intValue();

			if( sounds[nr] == null )
			{
				loadSound( nr );
			}

			sounds[nr].play();

			return true;
		}

		if (msg.type == Msg.CHAT_DIALOG_STRING)
		{
			if (lineclip != null) lineclip.play();
			print(com.getUserName(msg.from) + "> " + msg.arg);
			return true;
		}

		if( msg.type == MSG_SUPERCHAT_EVENT )
		{
			print( com.getUserName(msg.from) + " " + msg.arg );
			return true;
		}

		if( msg.type == MSG_PRIVATE_CHAT )
		{
			print( com.getUserName(msg.from)+" whispers to you: "+msg.arg );
			return true;
		}

		return false;
	}

	public boolean action(Event evt,Object what)
	{
		String text = input.getText();

		if (evt.target == input)
		{
			com.sendToAll( new Msg( Msg.CHAT_DIALOG_STRING, text ) );
			input.setText("");
			return true;
		}

		for( int i = 0; i < audiobuttons.length; i++ )
		{
			if( evt.target == audiobuttons[i] ) {
				com.sendToAll( new Msg( MSG_PLAY_SOUND, new Integer(i) ) );
				com.sendToAll( new Msg( MSG_SUPERCHAT_EVENT, soundnames[i][2] ) );
				return true;
			}
		}

		if( evt.target == facepanel ) {
			int id = ((Integer)evt.arg).intValue();

			// well if you need to know that a user was selected/
			// deselected, then you can do sth. here!
		}

		if( evt.target == kickbutton || evt.target == whisperbutton ) {
			Vector sel = facepanel.getSelectedUsers();
			Enumeration e = sel.elements();

			while( e.hasMoreElements() ) {
				int id = ((Integer)e.nextElement()).intValue();

				if( evt.target == kickbutton )
				{
					print( "You kicked "+com.getUserName( id )+" (reason: "+text+")." );
					com.sendTo(new Msg( Msg.KICK_USER, id, text ) );
				}
				else if( evt.target == whisperbutton ) {
					print( "You whisper to "+com.getUserName( id )+": "+text );
					com.sendTo(new Msg( SuperChat.MSG_PRIVATE_CHAT, id, text ));
				}
				input.setText("");
			}
		}

		return false;
	}
}

class FacePanel extends Panel {
	static final int COLUMNS = 10;
	static final int IMAGESIZE = 60;

	Hashtable users;
	ComObj com;

	ImageButton myImageButton = null;
	TextField myNameField = null;
	TextField myCommentField = null;
	Hashtable cachedata;

	RemoteFileDialog rfd = null;
	Frame rfdframe = null;
	String currentFaceName = null;
	Component refresh;

	public FacePanel() {
		super();
		setLayout( new VertLayout( VertLayout.STRETCH ) );
		users = new Hashtable();
	}

	public FacePanel( ComObj com, Component refresher ) {
		this();
		this.com = com;
		this.refresh = refresher;

		// add Myself right now, also I don't know anything
		// about me! This is done, that the facepanel size
		// is correct from the beginning.
		cachedata = addUserToPanel( " ", " ", true );
	}

	public void addUser( int id ) {
		boolean isitme = (id == com.getMyID());

		if( isitme )
		{
			// well now I get the information about me!

			users.put( new Integer( id ), cachedata );
			newUserInfo( id );
			return;
		}
	
		Hashtable data = addUserToPanel( com.getUserName( id ), getUserComment( id ), false );

		users.put( new Integer( id ), data );

		if( currentFaceName != null )
			com.sendTo( new Msg( SuperChat.MSG_NEW_FACE, id, currentFaceName ) );
	}

	public Hashtable addUserToPanel( String name, String comment, boolean isitme ) {
		Panel smallpanel = new Panel();
		Hashtable data = new Hashtable();
		ImageButton imgbutton;
		TextField nametf;
		TextField commenttf;
		Panel infopanel = new Panel();

		infopanel.setLayout( new BorderLayout() );
		infopanel.add( "North", nametf = new TextField( name, COLUMNS ) );
		infopanel.add( "Center", commenttf = new TextField( comment, COLUMNS ) );
		smallpanel.setLayout( new BorderLayout( 10, 10 ) );
		smallpanel.add( "West", imgbutton = new ImageButton( IMAGESIZE, IMAGESIZE, " " ) );
		smallpanel.add( "Center", infopanel );

		if( isitme ) {
			myImageButton = imgbutton;
			myNameField = nametf;
			myCommentField = commenttf;
		}
		else {
			nametf.setEditable( false );
			commenttf.setEditable( false );
			imgbutton.setSwitch( true );		// means use as a switch!
		}

		add( smallpanel );

		// I want the panel to be stretched, that the
		// new component fits on it! Here I don't want
		// to care about the parent-container (if 
		// I'm too large it's ok!)
		resize( size().width, preferredSize().height );
		layout();
		smallpanel.paintAll( smallpanel.getGraphics() );

		data.put( "name", nametf );
		data.put( "comment", commenttf );
		data.put( "imagebutton", imgbutton );
		data.put( "panel", smallpanel );

		return data;
	}

	public void removeUser( int id ) {
		Integer user = new Integer( id );
		Hashtable data;

		data = (Hashtable)users.get( user );
		Panel panel = (Panel)data.get( "panel" );
		remove( panel );

		users.remove( user );

		validate();
		paint( getGraphics() );
	}

	public Vector getSelectedUsers() {
		Vector selectedlist = new Vector();

		Enumeration e = users.keys();
		while( e.hasMoreElements() ) {
			Integer user = (Integer)e.nextElement();
			Hashtable data; 
			
			data = (Hashtable)users.get( user );
			ImageButton imgbutton = (ImageButton)data.get( "imagebutton" );

			if( imgbutton.getState() == true && user.intValue() != com.getMyID() ) {
				// user is selected
				selectedlist.addElement( user );
			}
		}

		return selectedlist;
	}

	public void newUserInfo( int id ) {
		Hashtable data = (Hashtable)users.get( new Integer( id ) );
		TextField name = (TextField)data.get( "name" );
		TextField comment = (TextField)data.get( "comment" );

		name.setText( com.getUserName( id ) );
		name.select( 0, 0 );
		comment.setText( getUserComment( id ) );
		comment.select( 0, 0 );
	}

	public String getUserComment( int id ) {
		String commentstring = (String)((User)com.getUser( id )).get( User.COMMENT );
		if( commentstring == null ) return " ";
		else return commentstring;
	}

	public void newFace( int id, Image face ) {
		Integer user = new Integer( id );

		Hashtable data = (Hashtable)users.get( user );
		ImageButton imgbutton = (ImageButton)data.get( "imagebutton" );

		imgbutton.setImages( face, face );
	}

	public boolean action( Event evt, Object what ) {
		if( evt.target == myImageButton ) {
			if( rfdframe != null ) return true;

			rfd = new RemoteFileDialog( com, "SuperChat.images", this );
			rfdframe = new Frame();
			rfdframe.add( "Center", rfd );
			rfdframe.pack();
			rfdframe.setTitle( "Choose your face..." );
			rfdframe.show();

			return true;
		}

		if( evt.target == rfd && rfd != null ) {
			if( what != null )
			{
				currentFaceName = (String)what;
				com.sendToAll( new Msg( SuperChat.MSG_NEW_FACE, com.getMyID(), currentFaceName ) );
			}

			rfdframe.hide();
			rfdframe.dispose();
			rfdframe = null;
			rfd = null;

			return true;
		}

		if( evt.target == myNameField || evt.target == myCommentField )
		{
			User ego = com.getUser( com.getMyID() );
			ego.put( User.NAME, myNameField.getText() );
			ego.put( User.COMMENT, myCommentField.getText() );

			// also tells other people (and myself :-)!
			com.setLocalUser( ego );
			return true;
		}

		Enumeration e = users.keys();
		while( e.hasMoreElements() ) {
			Integer user = (Integer)e.nextElement();
			Hashtable data; 
			
			data = (Hashtable)users.get( user );
			ImageButton imgbutton = (ImageButton)data.get( "imagebutton" );

			if( evt.target == imgbutton ) {
				// clicked on me: tell the refresh guy!

				refresh.action( new Event( this, Event.ACTION_EVENT, user ), user );
				return true;
			}
		}

		return false;
	}

	public void stop() {
		if( rfdframe != null )
		{
			rfdframe.hide();
			rfdframe.dispose();
			rfdframe = null;
		}
	}

	public boolean handleMsg( Msg msg )
	{
		if( msg.type == SuperChat.MSG_NEW_FACE )
		{
			Image image = com.loadImage( (String)msg.arg );
			newFace( msg.from, image );
			return true;
		}

		return false;
	}
}
