package como.commlet.scheduler;

import como.sys.*;
import como.io.*;
import como.util.*;
import java.io.*;

public class UserSchedule implements Saveable {
	static final int WEEK_DAYS = 7;
	static final int MIN_HOUR = 8;
	static final int MAX_HOUR = 22;
	static final int NR_HOURS = MAX_HOUR - MIN_HOUR + 1;

	static final byte ME_OK = 1;
	static final byte ME_WHYNOT = 0;
	static final byte ME_NO = -1;

	static final int BAD_FITNESS = -2;

	byte schedule[][];

	public UserSchedule() {
		// make the board a one bigger in each direction
		// needed, because of the scalas.
		schedule = new byte[WEEK_DAYS+1][NR_HOURS+1];
		clear();
	}

	public void clear() {
		set( ME_WHYNOT );
	}

	public void clickThrough( int x, int y ) {
		byte how = get( x, y );

		how++;

		if( how > ME_OK )
			how = ME_NO;

		set( x, y, how );
	}

	public void set( byte how ) {
		for( int x = 0; x <= WEEK_DAYS; x++ ) {
			for( int y = 0; y <= NR_HOURS; y++ ) {
				set( x, y, how );
			}
		}
	}

	synchronized public void setCol( int x, byte how ) {
		for( int y = 0; y <= NR_HOURS; y++ ) {
			set( x, y, how );
		}
	}

	synchronized public void setRow( int y, byte how ) {
		for( int x = 0; x <= WEEK_DAYS; x++ ) {
			set( x, y, how );
		}
	}

	synchronized public void set( int x, int y, byte how ) {
		schedule[x][y] = how;
	}

	synchronized public byte get( int x, int y ) {
		return schedule[x][y];
	}

	int fitness( int x, int y ) {
		switch( get( x, y ) )
		{
			case ME_NO:
				return BAD_FITNESS;

			default:
				return (int)get( x, y );
		}
	}

	int getMaxFitness() {
		return (int)ME_OK;
	}

	synchronized public void save( ObjectOutputStream s ) throws IOException {
		for( int x = 0; x <= WEEK_DAYS; x++ )
			s.writeObject( schedule[x] );
	}

	synchronized public void load( ObjectInputStream s ) throws IOException {
		for( int x = 0; x <= WEEK_DAYS; x++ )
		{
			schedule[x] = (byte[])s.readObject();

			if( schedule[x].length != NR_HOURS+1 )
				Debug.msg( 80, "UserSchedule.load(): schedule loaded has wrong size." );
		}
	}
}
