/*
* @(#)NicNacNoe.java    1.0 95/11/09 Ulrich Gall & Jan Kautz
*
* Copyright (c) 1996 Ulrich Gall & Jan Kautz
* uhgall@cip.informatik.uni-erlangen.de
* Hofmannstr. 48, D-91052 Erlangen, Germany, Fax: +49-9131-201358
*
* Permission to use, copy, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please contact us for  further copyright
* and licensing information.
*
* WE MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WE SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/

package como.commlet.nicnacnoe;

import java.util.*;
import java.awt.*;
import java.io.*;

import como.sys.*;
import como.util.*;
import como.awt.*;
import como.commlet.*;
import como.commlet.draw.*;
import como.commlet.superchat.*;
import como.commlet.userlist.*;
import como.commlet.messagelog.*;
import como.io.*;

/**
* This is an example how to program a MetaCommlet.
*/
public class NicNacNoe extends MetaCommlet {

public static int MSG_PUT_PIECE = 10011;
public static int MSG_NEW_BOARD = 10012;
public static int MSG_TURN = 10013;

public static int EVT_NEW_BOARD = 15002;
public static int EVT_CANCEL = 15003;
public static int EVT_CANCEL_INFORM = 15004;
public static int EVT_DISABLE_INFORM = 15005;

Board board = null;
GameControls controls = null;
TextField topTF;
MenuItem miNewBoard = null;
MenuItem miNextPlayer = null;
CheckboxMenuItem miInformTurn = null;

SmartFrame newboardframe;
SmartFrame notYourTurnFrame;
SmartFrame yourTurnFrame;
SmartFrame winFrame;
TextField xtf,ytf;
TextField wintf;

Hashtable gameparams;

int whoseturn = -1;// whose turn is it right now? -1 = nobody's
int nextturn = -1; // master has to remember whose turn it is next

public String getCommletName()
       {
       return "NicNacNoe";
       }

public String getCommletInfo()
       {
       return("NicNacNoe, demo Commlet, V 1.0, (c) Jan Kautz & Ulrich Gall");
       }

/**
* Commlets must have an empty constructor.
*/
public NicNacNoe()
       {
	gameparams = new Hashtable();
       }

public void init()
     {
     super.init();
	
     // include some basic Commlets in the menu
     SuperChat c = new SuperChat();
     addCommlet(c,"SuperChat");

     UserList ul = new UserList();
     addCommlet(ul,"Players");

     Menu men= new Menu("Game");
     miNewBoard = new MenuItem("New");
     miNextPlayer = new MenuItem("Skip this Player");
     if (com.iAmMaster()) {
		miNewBoard.enable();
		miNextPlayer.enable();
		add("North",topTF = new TextField("Select 'New' from the 'Game' menu to start a new Game"));
		}
	else {
		miNewBoard.disable();
		miNextPlayer.disable();
		add("North",topTF = new TextField("Please wait until a Game is started..."));
	}
	topTF.setEditable(false);		
     men.add(miNewBoard);
     men.add(miNextPlayer);
     getMenuBar().add(men);

	men = new Menu("Options");
	miInformTurn = new CheckboxMenuItem("Notify when it's your turn");
	miInformTurn.setState(true);
	men.add(miInformTurn);
	getMenuBar().add(men);


     board = new Board();
     add("Center",board);
     resize(480,480);
     }

/**
* This is called whenever a new user joins.
*/
public void addUser(int who) {
	int x,y;
	if (com.iAmMaster() && (gameparams.size() != 0)) {
		// send the current state of the game over the net
		// It would be nicer to send the whole board, but the regular IRCd
		// server can not process messages longer than 397 bytes. The Java IRCd can, though.
		Hashtable sendparams = (Hashtable)gameparams.clone();
		sendparams.remove(Board.PLAYERS); // we don't want to send too much over the net.
		com.sendTo(new Msg(MSG_NEW_BOARD,com.getMyID(),who,sendparams));
		for (x=0;x<board.xs;x++)
			for (y=0;y<board.ys;y++)
				if (board.get(x,y) != Board.EMPTY)
					com.sendTo(new Msg(MSG_PUT_PIECE, who,
						new Piece(x,y,board.get(x,y))));
		updateUserInfo(who);
	}
}
public void updateUserInfo(int who) {
	User u = com.getUser(who);
	board.updateUserInfo(u); // this keeps the old score and takes over the rest
	if (controls != null) controls.update(u);
	}

private void sendTurn(int t) {
       com.sendToAll(new Msg(MSG_TURN,new Integer(t)));
}
private int nextPlayer(int w) {
	// This is a little awkward, but shorter than implementing a container
	// class with circularly linked elements.
	Integer firstelement = null;
	Enumeration e = ((Hashtable)gameparams.get(Board.PLAYERS)).keys();
	while (e.hasMoreElements()) {
		Integer next = (Integer)e.nextElement();
		if (firstelement == null) firstelement = next;
		if (next.equals(new Integer(w))) {
			if (e.hasMoreElements()) {
				return ((Integer)e.nextElement()).intValue();
			}
			else {
				return firstelement.intValue();
			}
		}
	}
	return -1;
}
private void sendPutPiece(Piece p) {
       com.sendToAll(new Msg(MSG_PUT_PIECE,p));
}
private void doPutPiece(Piece p)
       {
       // Put the piece on the board
       if (p.p != -1) {
			board.set(p);
       	// Update the score...
			int add = 0;
			// left-right
	int c1,c2;
	c1 = 0; c2 = 0;
	while (board.get(p.x+c1,p.y) == p.p) c1++;
	while (board.get(p.x-c2,p.y) == p.p) c2++;
	add = add + board.getPoints(c1+c2-1);
	c1 = 0; c2 = 0;
	while (board.get(p.x,p.y+c1) == p.p) c1++;
	while (board.get(p.x,p.y-c2) == p.p) c2++;
	add = add + board.getPoints(c1+c2-1);
	c1 = 0; c2 = 0;
	while (board.get(p.x+c1,p.y+c1) == p.p) c1++;
	while (board.get(p.x-c2,p.y-c2) == p.p) c2++;
	add = add + board.getPoints(c1+c2-1);
	c1 = 0; c2 = 0;
	while (board.get(p.x-c1,p.y+c1) == p.p) c1++;
	while (board.get(p.x+c2,p.y-c2) == p.p) c2++;
	add = add + board.getPoints(c1+c2-1);
	
	if ((board.getScore(p.p) < board.getWinScore()) && (board.getScore(p.p)+add >= board.getWinScore())) {
		whoseturn = -1;
		nextturn = -1;
		if (com.iAmMaster()) sendTurn(-1); // just to make sure... not really necessary.
		if (p.p == com.getMyID()) {
			winFrame = new SmartFrame("Congratulations! You won the game");
		}
		else {
			winFrame = new SmartFrame(com.getUser(p.p).getName()+" has won the game.");
		}

	}
	board.setScore(p.p,board.getScore(p.p)+add);
	controls.update(p.p);
	}
}
private Hashtable loadParams(String filename) {
try {
Hashtable h = new Hashtable();
DataInputStream s = new DataInputStream(com.openInputStream(filename));
String l;
StringTokenizer st;
h.put(Board.DESCRIPTION,s.readLine());
st = new StringTokenizer(s.readLine()," ");
int w = new Integer(st.nextToken()).intValue();
st.nextToken();
int hei = new Integer(st.nextToken()).intValue();
h.put(Board.DIMENSION,new Dimension(w,hei));
st = new StringTokenizer(s.readLine());
int minp = new Integer(st.nextToken()).intValue();
st.nextToken();
int maxp = new Integer(st.nextToken()).intValue();
h.put(Board.NUMPLAYERS,new Dimension(minp,maxp));
st = new StringTokenizer(s.readLine()," ");
h.put(Board.WINSCORE,new Integer(st.nextToken()));
st = new StringTokenizer(s.readLine()," ");
while(st.hasMoreTokens()) {
	if (st.nextToken().equals("FALL")) h.put(Board.FALL,new Boolean(true));
} 
byte[] points = new byte[10];
int i;
for (i=0;i<10;i++) points[i] = 0;
l = s.readLine();
while ((l != null) && (l.length() > 0)) {
	st = new StringTokenizer(l," ");
	int a = new Integer(st.nextToken()).intValue();
	points[a] = (byte)(new Integer(st.nextToken()).intValue());
	l = s.readLine();
	}
h.put(Board.POINTS,points);
return h;
	}
catch (Exception e) {
new SmartFrame("Error loading game file:"+e);
return null;
}
}
public boolean action(Event evt,Object what) {
	if ((evt.target == miNextPlayer) && (gameparams.size() > 0)) {
		//  skip current player 
		sendTurn(nextturn);
		nextturn = nextPlayer(nextturn);
	}
	if ((evt.target == miNewBoard) && (newboardframe == null)) {
		if (winFrame != null) winFrame.dispose();
		winFrame = null;
		newboardframe = new SmartFrame(this);
		newboardframe.setTitle("NicNacNoe: New Game");
		Panel p = new RemoteFileDialog(com,"games.txt",this);
		newboardframe.add("North",new Label("Currently, there are "+com.getUsers().size()+ " players who would like to play. Which game would you like to start?"));
		newboardframe.add("Center",p);
		newboardframe.pack();
		newboardframe.show();
		return true;
		}
	if (evt.target instanceof RemoteFileDialog) {
		if (evt.arg == null ) {
			newboardframe.dispose();
			newboardframe = null;
			return true;
		}
		Hashtable pars = loadParams((String)evt.arg);
		if (pars != null) {
		Vector users = com.getUsers();
		int minplayers = ((Dimension)pars.get(Board.NUMPLAYERS)).width;
		int maxplayers = ((Dimension)pars.get(Board.NUMPLAYERS)).height;
		if (users.size() < minplayers) {
			new SmartFrame("You need at least "+minplayers+" players for this game.");
			return true;
		}
		if (users.size() > maxplayers) {
			new SmartFrame("At the most, "+maxplayers+
				" players can play this game. The other will have to watch");
		}
		gameparams = pars;
		int numplayers = maxplayers;
		if (users.size() < maxplayers) numplayers = users.size();
		Enumeration e = users.elements();
		byte[] scores = new byte[numplayers];
		int[] ids = new int[numplayers];
		int i = 0;
		while (e.hasMoreElements() && (i < numplayers)) {
			User u = (User)e.nextElement();
			ids[i] = u.getID();
			scores[i] = 0;
			i++;
		}
		gameparams.put(Board.IDS,ids);
		gameparams.put(Board.SCORES,scores);
		com.sendToAll(new Msg(MSG_NEW_BOARD,gameparams));
		newboardframe.dispose();
		newboardframe = null;
		return true;
		}
	}
	return false;
		
}
public void showYourTurn() {
	hideNotYourTurn();
	if (miInformTurn.getState()) {
		if (yourTurnFrame == null) {
			  yourTurnFrame = new SmartFrame(this,
				  "OK, thanks.", new Event(this,EVT_CANCEL_INFORM,null),
				  "I know. Shut up!", new Event(this,EVT_DISABLE_INFORM,null));
			  yourTurnFrame.setTitle("NicNacNoe: your turn...");
			  Panel p = new Panel();
			  // too make it look nicer under netscape win 95
			  p.setLayout(new VertLayout(VertLayout.STRETCH));
			  p.add(new Label(""));
			  p.add(new Label("It is now your turn.",Label.CENTER));
			  p.add(new Label(""));
			yourTurnFrame.add("North", p);
			yourTurnFrame.pack();
			yourTurnFrame.show();
		}	
	}
}
public void showNotYourTurn() {
	hideYourTurn();
	if (notYourTurnFrame == null) {
		notYourTurnFrame = new SmartFrame("It's not your turn!");
	}
}
public void hideNotYourTurn() {
	if (notYourTurnFrame != null) {
		notYourTurnFrame.dispose();
		notYourTurnFrame = null;
	}
}
public void hideYourTurn() {
	if (yourTurnFrame != null) {
		yourTurnFrame.dispose();
		yourTurnFrame = null;
	}
}
public boolean handleEvent(Event evt) {
if (evt.id == EVT_DISABLE_INFORM) {
	miInformTurn.setState(false);
	hideYourTurn();
	return true;
}
if (evt.id == EVT_CANCEL_INFORM) {
		hideYourTurn();
		return true;
}
return super.handleEvent(evt);
}
public boolean mouseDown(Event evt,int x,int y) {
       if (evt.target == board) {
			if (whoseturn == com.getMyID()) {
				if (board.get(x,y) == Board.EMPTY) {
					controls.disable(whoseturn);
					whoseturn = -1;
					sendPutPiece(new Piece(x,y,com.getMyID()));
					board.set(new Piece(x,y,com.getMyID()));
				}
       	}
       	else {
				showNotYourTurn();
       	}
       }
       return true;
}
/**
* Handle an incoming message. This is called by the ComObj.
*/
public synchronized boolean handleMsg(Msg msg) {
  	if (msg.type == Msg.NEW_USER_INFO) {
		if (gameparams != null) updateUserInfo(msg.from);
	}
  	else if (msg.type == MSG_NEW_BOARD) {
		gameparams = (Hashtable)msg.arg;
		whoseturn = -1;
		nextturn = -1;
		// We have to set the PLAYERS field, since it could not be sent...
		int i;
		Hashtable pl = new Hashtable();
		int [] ids = (int[])gameparams.get(Board.IDS);
		byte [] scores = (byte[])gameparams.get(Board.SCORES);
		for (i=0;i<ids.length;i++) {
			User u = com.getUser(ids[i]);
			if (u == null) {
				// construct a new user-- the information about this
				// user is not available yet.
				u = new User(ids[i],"Unknown user");
				u.put(u.COLOR,Color.white);
			}
			u.put(u.SCORE,new Integer(scores[i]));
			pl.put(new Integer(ids[i]),u);
		}
		gameparams.put(Board.PLAYERS,pl);
		board.reset(gameparams);
		Hashtable players = (Hashtable)gameparams.get(Board.PLAYERS);

		if (!players.containsKey(new Integer(com.getMyID()))) {
				new SmartFrame("You may watch this game and play when the next game is started.");
		}

		if (controls != null) remove(controls);

		controls = new GameControls(players);
		add("South",controls);
		topTF.setText((String)gameparams.get(Board.DESCRIPTION));
		layout();
		paintAll(getGraphics());

		if (com.iAmMaster()) {
		  sendTurn(com.getMyID());
		  nextturn = nextPlayer(com.getMyID());
		}
	}
	else if ((msg.type == MSG_TURN) && (controls != null)) {
		controls.disable(whoseturn);
		whoseturn = ((Integer)msg.arg).intValue();

		controls.enable(whoseturn);
		if (whoseturn == com.getMyID()) 
			showYourTurn();
		else
			hideYourTurn();
	}
	else if (msg.type == MSG_PUT_PIECE) {
		doPutPiece((Piece)msg.arg);
		if (com.iAmMaster()) {
			// send next-turn message
			sendTurn(nextturn);
			nextturn = nextPlayer(nextturn);
		}
	}
	else if (msg.type == Msg.NEW_MASTER) {
		miNewBoard.disable();
		miNextPlayer.disable();
		if (((Integer)msg.arg).intValue() == com.getMyID()) {
			miNewBoard.enable();
			miNextPlayer.enable();
		}
	}

   return super.handleMsg(msg);
	}
}


