/*
* @(#)GameCanvas.java    1.0 95/11/09 Ulrich Gall & Jan Kautz
*
* Copyright (c) 1996 Ulrich Gall & Jan Kautz
* uhgall@cip.informatik.uni-erlangen.de
* Hofmannstr. 48, D-91052 Erlangen, Germany, Fax: +49-9131-201358
*
* Permission to use, copy, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please contact us for  further copyright
* and licensing information.
*
* WE MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WE SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/

package como.commlet.nicnacnoe;

import java.util.*;
import java.applet.*;
import java.awt.*;
import java.io.*;
import java.awt.image.*;

import como.sys.*;
import como.util.*;
import como.awt.*;
import como.io.*;


public class GameControls extends Panel {

Hashtable sk;

public GameControls(Hashtable players) {
sk = new Hashtable(); // playernum -> scorekeeper
setLayout(new VertLayout(VertLayout.STRETCH));
Enumeration e = players.keys();
while (e.hasMoreElements()) {
	Object k = e.nextElement();
	User u = (User)players.get(k);
	ScoreKeeper s = new ScoreKeeper(u);
	s.disable();
	sk.put(k,s);
	add(s);
}
}
public void enable(int id) {
ScoreKeeper s = (ScoreKeeper)sk.get(new Integer(id));
if (s != null) s.enable();
}
public void disable(int id) {
ScoreKeeper s = (ScoreKeeper)sk.get(new Integer(id));
if (s != null) s.disable();
}
public void update(User u) {
ScoreKeeper s = (ScoreKeeper)sk.get(new Integer(u.getID()));
if (s != null) s.update(u);
}
public void update(int id) {
ScoreKeeper s = (ScoreKeeper)sk.get(new Integer(id));
if (s != null) s.update();
}
}
class ScoreKeeper extends Panel {

TextField nameTF;
TextField scoreTF;
Canvas colorshow;
User user;

public ScoreKeeper(User u) {
super();
user = u;
nameTF = new TextField(25);
nameTF.setEditable(false);
scoreTF = new TextField(8);
scoreTF.setEditable(false);
colorshow = new Canvas();
colorshow.resize(30,30);
colorshow.setBackground((Color)u.get(u.COLOR));
add(colorshow);
add(nameTF);
add(scoreTF);
update();
}
public void update(User u) {
user = u;
update();
}
public void update() {
colorshow.setBackground((Color)user.get(user.COLOR));
nameTF.setText(user.getName());
scoreTF.setText("Score: "+user.get(user.SCORE));
}
public void enable() {
scoreTF.enable();
nameTF.enable();
}
public void disable() {
scoreTF.disable();
nameTF.disable();
}
}
