/*
* @(#)Board.java    1.0 95/11/09 Ulrich Gall & Jan Kautz
*
* Copyright (c) 1996 Ulrich Gall & Jan Kautz
* uhgall@cip.informatik.uni-erlangen.de
* Hofmannstr. 48, D-91052 Erlangen, Germany, Fax: +49-9131-201358
*
* Permission to use, copy, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please contact us for  further copyright
* and licensing information.
*
* WE MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WE SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/

package como.commlet.nicnacnoe;

import java.util.*;
import java.awt.*;
import java.io.*;

import como.sys.*;
import como.util.*;
import como.awt.*;
import como.commlet.*;
import como.commlet.draw.*;
import como.commlet.chat.*;
import como.commlet.userlist.*;
import como.commlet.messagelog.*;
import como.io.*;

public class Board extends Canvas {


static final Integer DIMENSION = new Integer(1);
static final Integer NUMPLAYERS = new Integer(2);
static final Integer PLAYERS = new Integer(3);
static final Integer POINTS = new Integer(4);
static final Integer WINSCORE = new Integer(5);
static final Integer DESCRIPTION = new Integer(6);
static final Integer FALL = new Integer(7);
static final Integer IDS = new Integer(8);
static final Integer SCORES = new Integer(9);

static final int POINTSLENGTH = 10;

static int EMPTY = -1;
int [][] ar = null;
int xs = 0, ys = 0;
Hashtable params = null;

public Board() {
	}
public void reset(Hashtable pars) {
	params = pars;
	clear((Dimension)pars.get(DIMENSION));
}
public void updateUserInfo(User u) {
	if (params != null) {	
		Hashtable players = ((Hashtable)params.get(PLAYERS));
		if (players.containsKey(new Integer(u.getID()))) {
			// save old score
			u.put(u.SCORE,new Integer(getScore(u.getID())));
			players.put(new Integer(u.getID()),u);
			repaint();
		}
	}
}
public void clear(Dimension d) {
	xs = d.width;
	ys = d.height;
	ar = new int[xs][ys];
	int x,y;
	for (x=0;x<xs;x++) for (y=0;y<ys;y++) {
		ar[x][y] = EMPTY;
		}
	if (getGraphics() != null) paint(getGraphics());
}
public int getWinScore() {
	return ((Integer)params.get(WINSCORE)).intValue();
}
public int getPoints(int i) {
	if (i>=POINTSLENGTH) i = POINTSLENGTH-1;
	return ((byte[])params.get(POINTS))[i];
}
public User getPlayer(int who) {
	return (User)((Hashtable)params.get(PLAYERS)).get(new Integer(who));
}
public void setScore(int who,int newscore) {
	getPlayer(who).put(User.SCORE,new Integer(newscore));
}
public int getScore(int who) {
	if (getPlayer(who).containsKey(User.SCORE)) return ((Integer)getPlayer(who).get(User.SCORE)).intValue();
	else return 0;
}
public Rectangle getRect(int x, int y) {
	int xsize = size().width;
	int ysize = size().height;
	int csx = (xsize-1)/xs;
	int csy = (ysize-1)/ys;
	int bx = (xsize-csx*xs)/2;
	int by = (ysize-csy*ys)/2;
	return new Rectangle(bx+csx*x+1,by+csy*y+1,csx-2,csy-2);	
}
/**
* Returns the x/y position on the board that contains coordinates x,y
*/
public Point whichRect(int x, int y) {
if ((xs!=0)&&(ys!=0)) {
	int xsize = size().width;
	int ysize = size().height;
	int csx = (xsize-1)/xs;
	int csy = (ysize-1)/ys;
	int bx = (xsize-csx*xs)/2;
	int by = (ysize-csy*ys)/2;
	return new Point((x-bx)/csx,(y-by)/csy);
	}
	else return null;
}
public void paint(Graphics g) {
if (params != null) {
	g.clearRect(0,0,size().width,size().height);
	int x,y;
	int xmin = getRect(0,0).x;
	int xmax = getRect(xs,0).x;
	int ymin = getRect(0,0).y;
	int ymax = getRect(0,ys).y;
	for (x=0;x<=xs;x++) {
		Rectangle r = getRect(x,x);
		g.drawLine(r.x-1,ymin-1,r.x-1,ymax-1);
	}
	for (y=0;y<=ys;y++) {
		Rectangle r = getRect(y,y);
		g.drawLine(xmin-1,r.y-1,xmax-1,r.y-1);
	}
	for (x=0;x<xs;x++) {
		for (y=0;y<ys;y++) {
			drawCell(x,y);
		}
	}
}
}
public void drawCell(int x, int y) {
	Rectangle r = getRect(x,y);
	Graphics g = getGraphics();
	if (g != null) {
		g.clearRect(r.x,r.y,r.width,r.height);
		if (ar[x][y] != EMPTY) {
			if (getPlayer(ar[x][y]) != null) {
				g.setColor((Color)getPlayer(ar[x][y]).get(User.COLOR));
				if (ar[x][y] != EMPTY) g.fillOval(r.x,r.y,r.width,r.height);
			}
			else
				Debug.msg(34,"ID tries to paint that is not in player list: "+ar[x][y]);
		}
	}			
}
public int get(int x, int y) {
	if (ar != null) {
		if ((x<0) || (x >=xs)) return EMPTY;
		if ((y<0) || (y >=ys)) return EMPTY;
		return ar[x][y];
	}
	return EMPTY;
}
public void set(Piece p) {
	if (ar != null) {
	ar[p.x][p.y] = p.p;
	drawCell(p.x,p.y);
		}
	}
/**
* Converts the event's coordinates to the field in which the event occured
* and passes it to the parent.
*/
public boolean handleEvent(Event evt) {
	if ((getParent() != null) && (params != null)) {
		evt.target = this;
		int x = evt.x;
		int y = evt.y;
		evt.x = whichRect(x,y).x;
		evt.y = whichRect(x,y).y;
		if ((evt.x >=0) && (evt.x <xs)
		    && (evt.y >=0) && (evt.y <ys)) {
				if (params.containsKey(FALL)) {
					// let the piece fall
					if (get(evt.x,0) != EMPTY) {
						return true;
						}
					int ny = 1;
					while ((ny<ys-1) && (get(evt.x,ny+1) == EMPTY)) ny++;
					evt.y = ny;
				}
				evt.target = this;
				getParent().postEvent(evt);
			}
		}
	return true;
}
}

