package como.commlet.messagelog;

import java.awt.*;
import como.sys.*;
import como.util.*;
import como.commlet.*;

public class MessageLog extends WindowCommlet

{

	TextArea msgta;

	public MessageLog()
	{
	}

	public String getComletName()
	{
		return("MessageLog");
	}

	public String getComletInfo()
	{
		return("MessageLog, V 1.0, Jan Kautz & Ulrich Gall");
	}

	public void init()
	{
		super.init();
		msgta = new TextArea();
		msgta.setEditable(false);
		add("Center",msgta);
		resize(640,480);
		pack();
		print(getComletName());
		print(getComletInfo());
		print("Ready, waiting for messages...");
	}

	void print(String s)
	{
		msgta.insertText(s+"\n",msgta.getText().length());
	}

	public boolean handleMsg(Msg msg)
	{
		// Do not call super....
		print(msg.toString());
		return false; // since this "handling" does not really count
	}
}
