
package como.commlet.draw;

import como.io.*;
import como.util.*;
import java.awt.*;
import java.io.*;
import java.util.*; 
import java.lang.*;

public abstract class GraphicsObject implements Saveable
{
	protected Color color;
	protected  int x;
	protected  int y;
	String name;
	boolean filled;
	Graphics lastgraphics;
	Panel proppanel;

	public GraphicsObject()
	{
		color=Color.white;
		name = "Untitled-"+this.getClass().getName();
		x = 100;
		y = 100;
	}
	public abstract GraphicsObject getNew ();
	public boolean handleEvent(Event evt) {
		return false;
	}
	public void layoutPropPanel(Panel p) {
		p.removeAll();
		proppanel = p;
		updatePropPanel();
	}
	public void updatePropPanel() {
	}
	public boolean handlePropPanelEvent(Event evt,DrawCanvas d) {
		return false;
	}
	public void draw(Graphics g,Color c) {
		lastgraphics = g;
	}
	public void draw(Graphics g)
	{
		lastgraphics = g;
		draw(g,color);
	}
	public void redraw() {
		if (lastgraphics != null) draw(lastgraphics);
		// TODO: Do not take colormode into account
	}
	public void moveTo(int nx, int ny) {
		x = nx;
		y = ny;
		redraw();
		updatePropPanel();			
	}
	public Color getColor() {
		return color;		
	}
	public void setFilled(boolean b)
	{
		filled = b;
		redraw();
	}
		
	public int getX() { return x; }
	public int getY() { return y; }
	public void setColor(Color c) {
		color =c ;		
		redraw();	
		updatePropPanel();
	}
	public String toString() {
		return name +" "+x+" "+y+" "+color.getRed()+" "+color.getGreen()+" "+color.getBlue()+" ";
	}
	public void load(ObjectInputStream s) throws IOException {
		name = s.readString();
		x = s.readInt();
		y = s.readInt();
		color = (Color)s.readObject();
		filled = s.readBoolean();
	}
	public void save(ObjectOutputStream s)  throws IOException{
		s.writeString(name);
		s.writeInt(x);
		s.writeInt(y);
		s.writeObject(color);
		s.writeBoolean(filled);
	}
}
