
package como.commlet.draw;

import como.io.*;
import como.util.*;
import java.awt.*;
import java.io.*;
import java.util.*; import java.lang.*;
/******
* GOText
*/
public class GOText extends GraphicsObject
{
	Font font;
	private StringBuffer text;
	TextField textTF;
	int nextx, nexty;
	public GOText()
	{
		super();
		font = new Font("Courier",Font.PLAIN,24);
		text = new StringBuffer();
		nextx = x;
		nexty = y + 20;
	}
	public GraphicsObject getNew() {
		GOText go = new GOText();
		go.color = color;
		go.x = nextx;
		go.y = nexty; // TODO
		go.name = name;
		go.font = font;
		go.textTF = textTF;
		textTF = null;
		go.updatePropPanel();
		return go;
	}

	public void draw(Graphics g,Color c)
	{
		lastgraphics = g;
		g.setColor(c);
		g.setFont(font);
		g.drawString(text.toString(),getX(),getY());
	}
	public void layoutPropPanel(Panel p) {
		p.removeAll();
		p.setLayout(new BorderLayout());
		if (textTF == null) textTF = new TextField(text.toString());
		p.add("North",new Label("Enter text below"));
		p.add("Center",textTF);
		updatePropPanel();
	}
	public void updatePropPanel() {
		if (textTF != null) {
			if (text != null) textTF.setText(text.toString());
			if (textTF.getParent() != null) textTF.getParent().repaint();			
		}
	}
	public boolean handlePropPanelEvent(Event evt,DrawCanvas d) {
		if (evt.target instanceof TextField) {
			if (evt.id == Event.ACTION_EVENT) {
				nextx = x;
				nexty = y+20;
				d.postEvent(new Event(d,DrawCanvas.EVENT_ACCEPT,null));
			}
			text= new StringBuffer(textTF.getText()); 
			d.repaint();
			return false;
		}
		return false;
	}

	public boolean handleEvent(Event evt)
	{
		if (evt.id == Event.MOUSE_DOWN)
		{
			if (text.length() > 0)
			{
				evt.id = DrawCanvas.EVENT_ACCEPT;
				nextx = evt.x;
				nexty = evt.y;
				return true;
			}
			moveTo(evt.x,evt.y);
			return true;
		}
		else if (evt.id == Event.KEY_PRESS)
		{
			if ((evt.key == 127) || (evt.key == '\b')) {
				if (text.length()>0) text.setLength(text.length()-1);
				if (evt.target instanceof DrawCanvas) {
					((DrawCanvas)evt.target).repaint();
				}
			}
			else if (evt.key == '\n') {
				evt.id = DrawCanvas.EVENT_ACCEPT;
				nextx = x;
				nexty = y+20;
				return true;
			}
			else text.append((char)evt.key);
			updatePropPanel();
			return true;
		}                           
		return false;		
	}
	
	public String toString()
	{
		return super.toString() + font.getName()+" "+ font.getSize()+" "+font.getStyle()+" "
		+text.toString();
	}
	public void  save(ObjectOutputStream s) throws IOException {
		super.save(s);
		s.writeObject(font);
		s.writeString(text.toString());
	}
	public void  load(ObjectInputStream s) throws IOException {
		super.load(s);
		font = (Font)s.readObject();
		text = new StringBuffer(s.readString());
	}
}
