
package como.commlet.draw;

import como.io.*;
import como.util.*;
import java.awt.*;
import java.io.*;
import java.util.*; import java.lang.*;

/******
* GOPolygon
*/
public class GORect extends GraphicsObject
{
	int width;
	int height;

	public GORect()
	{
		super();
	}		
	public GraphicsObject getNew ()  {
		GORect go = new GORect();
		go.color = color;
		go.name = name;
		go.x = x;
		go.y = y;
		go.width = 0;
		go.height = 0;
		go.filled = filled;
		return go;
	}

	public void draw(Graphics g,Color c)
	{
		lastgraphics = g;
		g.setColor(c);
		if ((width !=0) && (height !=0)) {
			int x0,y0,w,h;
			if (width > 0) {
				x0 = x; 
				w = width; 
			} 
			else { 
				x0 = x + width; 
				w = -width; 
			}
			if (height > 0) {
				y0 = y; 
				h = height; 
			} 
			else {
				y0 = y + height; 
				h = -height; 
			}
			if (filled) g.fillRect(x0,y0,w,h); 
			else g.drawRect(x0,y0,w,h);
		}
	}		
	public boolean handleEvent(Event evt)
	{
		if (evt.id == Event.MOUSE_DRAG)
		{
			height = evt.y - y;
			width = evt.x - x;
			if (evt.metaDown()) {
				if (height > width) height = width;
				else width = height;
			}
			if (evt.target instanceof DrawCanvas) ((DrawCanvas)evt.target).repaint();
			return true;
		}
		else if (evt.id == Event.MOUSE_UP)
		{
			evt.id = DrawCanvas.EVENT_ACCEPT;
			return true;
		}
		else if (evt.id == Event.MOUSE_DOWN)
		{
			x = evt.x;
			y = evt.y;
			return true;
		}
		return false;
	}
	public String toString() {
	return super.toString() + "Width = "+width+"Height = "+height;
	}
	public void save(ObjectOutputStream s) throws IOException {
		super.save(s);
		s.writeInt(width);
		s.writeInt(height);
	}
	public void load(ObjectInputStream s) throws IOException {
		super.load(s);
		width = s.readInt();
		height = s.readInt();
	}
}
