
package como.commlet.draw;

import como.io.*;
import como.util.*;
import java.awt.*;
import java.io.*;
import java.util.*; import java.lang.*;

/******
* GOPolygon
*/
public class GOPolygon extends GraphicsObject
{
	Polygon pol;
	boolean forcedcut = false;

	public GOPolygon()
	{
		super();
		pol = new Polygon();
		filled = true;
		forcedcut = false;
	}		
	public GraphicsObject getNew ()  {
		GOPolygon go = new GOPolygon();
		go.color = color;
		go.name = name;
		go.x = x;
		go.y = y;
		go.filled = filled;
		go.pol = new Polygon();
		if (forcedcut) go.addPoint(x,y);
		go.forcedcut = false;
		forcedcut = false;
		return go;
	}

	public void addPoint(int x, int y) {
		pol.addPoint(x,y);
	}
	public void draw(Graphics g,Color c)
	{
		lastgraphics = g;
		g.setColor(c);
		if (pol.npoints>0) {
			if (filled) g.fillPolygon(pol);
			else g.drawPolygon(pol);
		}
	}		
	public boolean handleEvent(Event evt)
	{
		if (evt.id == Event.MOUSE_DRAG)
		{
			addPoint(evt.x,evt.y);
			if (pol.npoints > 30)	{
				evt.id = DrawCanvas.EVENT_ACCEPT;
				forcedcut = true;
				x = evt.x;
				y = evt.y;
			}
			return true;
		}
		else if (evt.id == Event.MOUSE_UP)
		{
			addPoint(evt.x,evt.y);
			evt.id = DrawCanvas.EVENT_ACCEPT;
			return true;
		}
		else if (evt.id == Event.MOUSE_DOWN)
		{
			addPoint(evt.x,evt.y);
			return true;
		}
		return false;
	}
	public String toString()
	{
		StringBuffer s = new StringBuffer();            
		if (filled) s.append("F "); else s.append("N ");
		s.append(pol.npoints+" ");
		int i;
		for (i=0;i<pol.npoints;i++)
		s.append(pol.xpoints[i]+" "+pol.ypoints[i]+" ");
		return super.toString()+s.toString();
	}
	public void save(ObjectOutputStream s) throws IOException {
		super.save(s);
		s.writeInt(pol.npoints);
		int i;
		for (i=0;i<pol.npoints;i++) {
			s.writeShort(pol.xpoints[i]);
			s.writeShort(pol.ypoints[i]);
		}
			
	}
	public void load(ObjectInputStream s) throws IOException {
		super.load(s);
		pol.npoints = s.readInt();
		pol.xpoints = new int[pol.npoints];
		pol.ypoints = new int[pol.npoints];
		int i;
		for(i=0;i<pol.npoints;i++)
		{
			pol.xpoints[i] = s.readShort();
			pol.ypoints[i] = s.readShort();
		}
	}
}
