
package como.commlet.draw;

import como.io.*;
import como.util.*;
import java.awt.*;
import java.io.*;
import java.util.*; import java.lang.*;

/******
* GOPolygon
*/
public class GOOval extends GORect
{

	public GOOval()
	{
		super();
		filled = false;
	}		
	public GraphicsObject getNew ()  {
		GOOval go = new GOOval();
		go.color = color;
		go.name = name;
		go.x = x;
		go.y = y;
		go.width = 0;
		go.height = 0;
		go.filled = filled;
		return go;
	}

	public void draw(Graphics g,Color c)
	{
		lastgraphics = g;
		g.setColor(c);
		if ((width !=0) && (height !=0)) {
			int x0,y0,w,h;
			if (width > 0) {
				x0 = x; 
				w = width; 
			} 
			else { 
				x0 = x + width; 
				w = -width; 
			}
			if (height > 0) {
				y0 = y; 
				h = height; 
			} 
			else {
				y0 = y + height; 
				h = -height; 
			}
			if (filled) g.fillOval(x0,y0,w,h); 
			else g.drawOval(x0,y0,w,h);
		}
	}		
	public String toString() {
	return super.toString() + "Width = "+width+"Height = "+height;
	}
	public void save(ObjectOutputStream s) throws IOException {
		super.save(s);
		s.writeInt(width);
		s.writeInt(height);
	}
	public void load(ObjectInputStream s) throws IOException {
		super.load(s);
		width = s.readInt();
		height = s.readInt();
	}
}

