
package como.commlet.draw;

import como.io.*;
import como.util.*;
import java.awt.*;
import java.io.*;
import java.util.*; import java.lang.*;

/******
* GOPolygon
*/
public class GOLine extends GraphicsObject
{
	int x2,y2;

	public GOLine()
	{
		super();
		filled = false;
	}		
	public GraphicsObject getNew ()  {
		GOLine go = new GOLine();
		go.color = color;
		go.name = name;
		go.x = go.x2 = x;
		go.y = go.y2 = y;
		return go;
	}

	public void draw(Graphics g,Color c)
	{
		lastgraphics = g;
		g.setColor(c);
		if ((x2 != x) || (y2 != y)) g.drawLine(x,y,x2,y2);
	}		
	public boolean handleEvent(Event evt)
	{
		if (evt.id == Event.MOUSE_UP)
		{
			evt.id = DrawCanvas.EVENT_ACCEPT;
			return true;
		}
		else if (evt.id == Event.MOUSE_DOWN)
		{
			x = x2 = evt.x;
			y = y2 = evt.y;
			return true;
		}
		else if (evt.id == Event.MOUSE_DRAG)
		{
			if (evt.metaDown()) {
				if (Math.abs(evt.x-x) > Math.abs(evt.y-y))
					evt.y = y;
				else evt.x = x;
			}
			x2 = evt.x;
			y2 = evt.y;
			if (evt.target instanceof DrawCanvas) {
				((DrawCanvas)evt.target).repaint();
			}
			return true;
		}
		return false;
	}
public void save(ObjectOutputStream s) throws IOException {
	super.save(s);
	s.writeInt(x2);
	s.writeInt(y2);
	}
public void load(ObjectInputStream s) throws IOException {
	super.load(s);
	x2 = s.readInt();
	y2 = s.readInt();
	}
}

