
package como.commlet.draw;

import como.io.*;
import como.util.*;
import como.sys.*;
import como.awt.*;
import java.awt.*;
import java.io.*;
import java.util.*; 
import java.lang.*;

/******
* GOPolygon
*/
public class GOImage extends GORect
{

	String imagename;
	Image image;

	Component canvas;
	ComObj comobj;

	Frame fdFrame;
	Panel proppanel;

	public GOImage()
	{
		super();
		imagename = "defaultimg";
		image = null;
	}		
	public void setData(ComObj c,Component d) {
	// urgs.
		canvas = d;
		comobj = c;
		if (image == null) image = c.loadImage(imagename);
	}
	public void setImage(String n) {
		imagename = n;
		image = comobj.loadImage(imagename);
	}
	public GraphicsObject getNew ()  {
		GOImage go = new GOImage();
		go.color = color;
		go.name = name;
		go.x = x;
		go.y = y;
		go.width = 0;
		go.height = 0;
		go.filled = filled;
		go.imagename = imagename;
		go.image = image;
		go.canvas = canvas;
		go.comobj = comobj;
		go.fdFrame = fdFrame;
		go.proppanel = proppanel;
		return go;
	}
        public void showFD() {
	if (fdFrame == null) {
		RemoteFileDialog rfd = new RemoteFileDialog( comobj, "Draw.images", proppanel );
		fdFrame = new Frame();
		fdFrame.setTitle("Choose an image to paste");
		fdFrame.add("Center",rfd);
		fdFrame.pack();
		fdFrame.show();
	}
	}
	public void updatePropPanel() {
		if ((proppanel != null) && (proppanel.getParent() != null)) {
			proppanel.getParent().repaint();
		}
	}
        public void layoutPropPanel(Panel p) {
		proppanel = p;
		p.removeAll();
		p.setLayout(new BorderLayout());
		p.add("Center",new Button("Choose Picture"));
		updatePropPanel();
		showFD();
	}
        public boolean handlePropPanelEvent(Event evt,DrawCanvas d) {
		if  (evt.target instanceof Button) {
			showFD();
		}
		else if  (evt.target instanceof RemoteFileDialog) {
			String s = (String)evt.arg;
			if (s != null) {
				imagename = s;
				setImage(s);
			}
			else {
			fdFrame.hide();
			fdFrame.dispose();
			fdFrame = null;
			}
		}
	return true;
	}
	public void draw(Graphics g,Color c)
	{
		lastgraphics = g;
		g.setColor(c);
		if ((width !=0) && (height !=0)) {
			int x0,y0,w,h;
			if (width > 0) {
				x0 = x; 
				w = width; 
			} 
			else { 
				x0 = x + width; 
				w = -width; 
			}
			if (height > 0) {
				y0 = y; 
				h = height; 
			} 
			else {
				y0 = y + height; 
				h = -height; 
			}
			if (image != null) {
				if (((Component.ALLBITS | Component.ERROR) & canvas.checkImage(image,w,h,canvas)) == 0) {
					g.drawRect(x0,y0,w,h);
				}
				g.drawImage(image,x0,y0,w,h,canvas);
			}
			else g.fillRect(x0,y0,w,h);
		}
	}		
	public boolean handleEvent(Event evt)
	{
		if (evt.id == Event.MOUSE_DRAG)
		{
			height = evt.y - y;
			width = evt.x - x;
			if (evt.metaDown()) {
				if ((image != null) && (image.getHeight(canvas) != 0) && (image.getWidth(canvas) != 0))
					height = width * image.getHeight(canvas) / image.getWidth(canvas);
			}
			if (evt.target instanceof DrawCanvas) ((DrawCanvas)evt.target).repaint();
			return true;
		}
		else if (evt.id == Event.MOUSE_UP)
		{
			evt.id = DrawCanvas.EVENT_ACCEPT;
			return true;
		}
		else if (evt.id == Event.WINDOW_DESTROY)
		{
			if (fdFrame != null) {
				fdFrame.hide();
				fdFrame.dispose();
				fdFrame = null;
			}
			return true;
		}
		else if (evt.id == Event.MOUSE_DOWN)
		{
			x = evt.x;
			y = evt.y;
			return true;
		}
		return false;
	}
	public String toString() {
	return super.toString() + " Name = "+imagename;
	}
	public void save(ObjectOutputStream s) throws IOException {
		super.save(s);
		s.writeString(imagename);
	}
	public void load(ObjectInputStream s) throws IOException {
		super.load(s);
		imagename = s.readString();
	}
}
