/*
* @(#)ClassRoom.java    1.0 95/11/09 Ulrich Gall & Jan Kautz
*
* Copyright (c) 1996 Ulrich Gall & Jan Kautz
* uhgall@cip.informatik.uni-erlangen.de
* Hofmannstr. 48, D-91052 Erlangen, Germany, Fax: +49-9131-201358
*
* Permission to use, copy, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please contact us for  further copyright
* and licensing information.
*
* WE MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WE SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/
package como.commlet.classroom;

import java.util.*;
import java.awt.*;
import java.io.*;

import como.sys.*;
import como.util.*;
import como.awt.*;
import como.commlet.*;
import como.commlet.draw.*;
import como.commlet.superchat.*;
import como.commlet.messagelog.*;
import como.commlet.userlist.*;

/**
* This is an example how to program a MetaCommlet.
*/
public class ClassRoom extends MetaCommlet {

static final int MSG_TEXT_CHANGED = 10001;
// Pick any numbers >10000 if your Commlet is derived from any of our classes
// All MSG numbers should be within an interval of 1000 for each class, thus,
// a class derived from this one should start at 11000 etc.

TextArea myText;
Button myButton;

// This is a TextArea we will place in the MetaCommlets window and let the
// user edit.

public String getCommletName()
       {
       String s = "ClassRoom";
       if (getTopicTextField() != null) s = s + " with topic ='"+ getTopicTextField().getText()+"'";
       return s;
       }

public String getCommletInfo()
       {
       return("ClassRoom, demo Commlet, V 1.0, (c) Jan Kautz & Ulrich Gall");
       }

/**
* Commlets must have an empty constructor.
*/
public ClassRoom()
       {
       }

public void init()
     {
     super.init();
     setTitle("Como ClassRoom Commlet");		
     // include some basic Commlets in the menu
     SuperChat c = new SuperChat();
     addCommlet(c,"Class room");
     c.setTitle("Como ClassRoom Commlet: class room window");

     Draw d = new Draw();
     addCommlet(d,"Board");
     d.setTitle("Como ClassRoom Commlet: Board");

     UserList ul = new UserList();
     addCommlet(ul,"Students");
     ul.setTitle("Como ClassRoom Commlet: Student list");

     String s = "\n\n    Welcome to todays _________ class.\n";
     myText=new TextArea(s);

     add("Center",myText);
	myButton = new Button("Update This Text On The Students' Screens");
     add("South",myButton);
     pack();
	if (com.iAmMaster()) myButton.show(); else myButton.hide();
	myText.setEditable(com.iAmMaster());
     }
/**
* This is called whenever a new user joins.
*/
public void addUser(int who) {
	if (com.iAmMaster()) 
		com.sendTo(new Msg(MSG_TEXT_CHANGED,who,myText.getText()));
	}

public boolean handleEvent(Event evt)
       {
       if (super.handleEvent(evt)) return true;
       if (evt.target == myButton)
          {
          com.sendToOthers(new Msg(MSG_TEXT_CHANGED,myText.getText()));
          // It may be better style to call sendToAll, but here it doesnt
          // matter at all.
	  myText.requestFocus();
          return true;
          }
       return false;
       }

/**
* Handle an incoming message. This is called by the ComObj.
*/
public boolean handleMsg(Msg msg)
       {
       if (msg.type == Msg.NEW_MASTER)
          {
		int m = ((Integer)msg.arg).intValue();
		myText.setEditable(com.iAmMaster());
		if (m == com.getMyID())
			myButton.show();
		else
			myButton.hide();
          }
       if (msg.type == MSG_TEXT_CHANGED)
          {
          myText.setText(msg.arg.toString());
          }
       return (super.handleMsg(msg));
       }
}
