package como.commlet.chat;

import java.awt.*;
import java.util.Hashtable;
import java.io.*;
import java.util.*;

import como.sys.*;
import como.util.*;
import como.awt.*;
import como.commlet.*;

public class Chat extends WindowCommlet
{
	TextArea dialog;
	TextField input;
	Hashtable usernames;

	public Chat() {
		usernames = new Hashtable();
	}

	public String getCommletName()
	{
		return "Basic Chat Commlet";
	}

	public String getCommletInfo()
	{
		return
		"(c) 1996 Ulrich Gall & Jan Kautz\n"+
		"\n";
	}

	public void init()
	{
		// always call super.init() here!!!
		super.init();

		input = new TextField();
		setLayout(new BorderLayout());
		add("South",input);
		Panel p = new Panel();
		p.setLayout(new BorderLayout());
		p.add("West",new Label("Current Topic: "));
		p.add("Center",getTopicTextField());
		add("North",p);
		dialog = new TextArea();
		dialog.setEditable(false);
		add("Center",dialog);
		pack();

		print(getCommletName());
		print(getCommletInfo());       
		print("Ready, waiting for messages...");
	}

	/** new user handling
	 */
	public void addUser(int TheNewUser)
	{
		print(com.getUserName(TheNewUser) + " has joined the conversation.");
		usernames.put(new Integer(TheNewUser),com.getUserName(TheNewUser));
	}

	/** a userLeft
	 */
	public void userLeft(int RankWhoLeft)
	{
		print(com.getUserName(RankWhoLeft) + " has left the conversation.");
	}

	/** if you override this, you have to call super.stop() at the end!
	 */
	public void stop()
	{
		com.sendToAll(new Msg(Msg.CHAT_DIALOG_STRING,"bye bye..."));
		super.stop();
	}

	void print(String s)
	{
		int width = dialog.size().width;
		Font font = dialog.getFont();
		FontMetrics fm = null;

		if( font != null ) fm = dialog.getFontMetrics(font);

		if( fm != null ) {
			width -= fm.stringWidth( "MMMM" );	// just like that.

			StringTokenizer st = new StringTokenizer( s, " " );
			StringBuffer line = new StringBuffer();
	
			while( st.hasMoreTokens() ) {
				String next = st.nextToken();

				if( fm.stringWidth( line.toString()+next+" " ) < width )
					line.append( " "+next );
				else
				{
					dialog.insertText(line+"\n",dialog.getText().length());
					line = new StringBuffer( "   "+next );
				}
			}
			dialog.insertText(line+"\n",dialog.getText().length());
		}
		else
			dialog.insertText(s+"\n",dialog.getText().length());

		// move the textfield down!
		int l = dialog.getText().length()-2;
		dialog.select( l, l );
	}

	/** This gets called if a message arrives.
	 */
	public boolean handleMsg(Msg msg)
	{
		if (super.handleMsg(msg)) return true;

		if (msg.arg == null) msg.arg = "";
		if (msg.type == Msg.NEW_USER_INFO)
		{
			String newname = com.getUserName(msg.from);
			User newuser = com.getUser(msg.from);
			if (!usernames.get(new Integer(msg.from)).equals(newname))
			{
				print(usernames.get(new Integer(msg.from)) + " is now known as "+newname);
				usernames.put( new Integer(msg.from), newname );
			}
			if (((User)newuser).containsKey(User.COMMENT)) 
				if (((User)newuser).get(User.COMMENT).toString().length() < 1)
					print(newname + "'s new comment: "+((User)newuser).get(User.COMMENT));
			return true;
		}
		if (msg.type == Msg.CHAT_DIALOG_STRING)
		{
			print(com.getUserName(msg.from) + "> " + msg.arg);
			return true;
		}
		return false;
	}

	public boolean action(Event evt,Object what)
	{
		if (evt.target == input)
		{
			com.sendToAll(new Msg(Msg.CHAT_DIALOG_STRING,input.getText()) );
			((TextField)evt.target).setText("");
			return true;
		}
		return false;
	}
}
