/*
* @(#)MetaCommlet.java    1.0 95/11/09 Ulrich Gall & Jan Kautz
*
* Copyright (c) 1996 Ulrich Gall & Jan Kautz 
* uhgall@cip.informatik.uni-erlangen.de
* Hofmannstr. 48, D-91052 Erlangen, Germany, Fax: +49-9131-201358
*
* Permission to use, copy, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please contact us for  further copyright 
* and licensing information.
*
* WE MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WE SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/
package como.commlet;

import java.util.*;
import java.awt.*;
import java.applet.Applet;
import java.io.*;
import java.awt.*;
import java.util.Date;
import como.sys.*;
import como.util.*;

/**
 * This is a WindowCommlet that has a list of commlets. These commlets
 * are all started and added to the menu bar. All messages are send to
 * all commlets in the list.
 *
 * This should be subclassed, so that the commlets can be explicitly added
 * in the init() method after super.init() has been called.
 * Refer to MultiComm for an example.
 */
public abstract class MetaCommlet extends WindowCommlet
{
Vector            myCommlets;     // int -> Commlet
MenuBar           myMenuBar;
Menu              myCommletMenu;
Hashtable         myTargetTable; // CheckBoxMenuItem -> Commlet

static String MB_COMMLET = "View";

public MetaCommlet()
{
       myCommlets = new Vector();
       myTargetTable = new Hashtable();
       myCommletMenu= new Menu(MB_COMMLET);
}

public String getCommletName()
{
       return("Base class MetaCommlet");
}

public void init()
{
     super.init();
     myMenuBar = new MenuBar();
     myMenuBar.add(myCommletMenu);
     setMenuBar(myMenuBar);
     resize(300,100);
     pack();
}

/**
 * To add a Commlet to your MetaCommlet subclass, call this in your init() method
 * after instantiating the Commlet.
 */
public void addCommlet(Commlet commlet, String name)
{
    commlet.setCom(com);
    commlet.setMetaCommlet(this);
    commlet.init();
    commlet.hideCommlet();
    myCommlets.addElement(commlet);
    MenuItem nm = new CheckboxMenuItem(name);
    myCommletMenu.add(nm);
    myTargetTable.put(nm,commlet);
}

protected void setStateOfMenuItemBelongingTo(Commlet c,boolean newstate)
{
              // We need to setstate() the CheckBoxMenuItem for this
              Enumeration e = myTargetTable.keys();
              while (e.hasMoreElements())
              {
                    Object key = e.nextElement();
                    if (c == myTargetTable.get(key))
                    {
                       ((CheckboxMenuItem)key).setState(newstate);
                    }
              }
}

public void stop()
{                                         
     Enumeration e = myCommlets.elements();
     while (e.hasMoreElements())
     {    
           Object o = e.nextElement();
           if (o instanceof Commlet)
           {
              ((Commlet)o).stop();
           }
     }
     super.stop();
}

/**
 * If you override this in your subclass, call this first. It returns true if one of
 * the sub Commlets has handled the Event. A MessageLog does not return true
 * on any events; it just looks at them.
 */
public boolean handleMsg(Msg msg)
   {
   boolean hasbeenhandled = super.handleMsg(msg);
     Enumeration e = myCommlets.elements();
     while (e.hasMoreElements())
           {
           Object c;
           if ((c = e.nextElement()) instanceof Commlet)
              {
              if (((Commlet)c).handleMsg(msg)) hasbeenhandled = true;
              }
           }
   return hasbeenhandled;
   }

public boolean handleEvent(Event evt)
{
   if (myTargetTable.containsKey(evt.target))
   {
      CheckboxMenuItem m = (CheckboxMenuItem) evt.target;
      WindowCommlet c = (WindowCommlet) myTargetTable.get(evt.target);

      if (m.getState())
         c.showCommlet();
      else
         c.hideCommlet();

      return true;
   }
   return super.handleEvent(evt);
}
}
