/*
* @(#)Commlet.java    1.0 95/11/09 Ulrich Gall & Jan Kautz
*
* Copyright (c) 1996 Ulrich Gall & Jan Kautz 
* uhgall@cip.informatik.uni-erlangen.de
* Hofmannstr. 48, D-91052 Erlangen, Germany, Fax: +49-9131-201358
*
* Permission to use, copy, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please contact us for  further copyright 
* and licensing information.
*
* WE MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WE SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/

package como.commlet;

import java.util.*;
import como.sys.*;
import como.util.*;

/**
 * The interface for Commlets. You should not have to refer to this; most Commlets
 * should be derived from WindowCommlet or MetaCommlet.
 */
public interface Commlet
{
	/**
	 * @return the name of the session
	 */
	public String getSessionName();

	/**
	 * @return the name of the commlet
	 */
	public String getCommletName();

	/**
	 * @return some information about the commlet
	 */
	public String getCommletInfo();

	/**
	 * For MetaCommlets.
	 */
	public void setMetaCommlet(MetaCommlet m);

	/**
	 * This is called after setCom has been called. If you override it, 
	 * call super.init() in the first line!.
	 */
	public void init();

	/**
	 * This shows the commlet and does some basic inits.
	 * Called from outside, if it should the commlet should be shown.
	 */
	public void showCommlet();

	/**
	 * This hides the commlet. Not needed at the moment by ComObj, but by
	 * WindowCommlet/MetaCommlet.
	 */
	public void hideCommlet();

	/**
	 * Sets the corresponding ComObj for this commlet.
	 * @param c the ComObj
	 */
	void setCom(ComObj c);

	/**
	 * Called when it will stop. In this routine you
	 * have to call ComObj.logout() at the end!
	 */
	void stop();

	/**
	 * this Method is called, if you receive a new message.
	 * msg.from will be the ID of the sender. In msg.type
	 * you'll find the message ID.  * In msg.arg
	 * you'll find the object that was sent.
	 * @param msg the Msg
	 * @return true, if you handled the message (for handled messages that
	 * might be interesting for other commlets in a metacommlet
	 * do return false then!). false if not handled (like in AWT: handleEvent())
	 */
	boolean handleMsg(Msg msg);// returns True if message has been handled

	/**
	 * Override this and return true if you want to permit the user u to 
	 * join the Commlet.
	 */
	boolean isUserAdmitted(User u);
}
