package como.awt;

import java.awt.*;
import como.*;
import como.util.Debug;

public class SmartFrame extends java.awt.Frame {
	
private Component notify = null;
private Button okbutton = null;
private Button cancelbutton = null;
private Event okevent = null;
private Event cancelevent = null;
private boolean notifyall = false;

	/**
	 * Constructs a new SmartFrame. This Frame only reacts to the
	 * WINDOW_DESTROY Event.
	 */
	public SmartFrame() {
	}

	/**
	 * Constructs a new SmartFrame. If a notifier Component is given,
	 * Events are posted there. Otherwise, this Frame only reacts to the
	 * WINDOW_DESTROY Event.
	 */
	public SmartFrame(Component c) {
		notify = c;
		notifyall = true;
	}

	/**
	* Constructs a new SmartFrame with two Buttons: OK and Cancel. If OK is pressed,
	* Evt is sent to component. If Cancel is pressed, evtcancel is sent.
	* It is not pack()'ed or show()'n.
	*/
	public SmartFrame(Component c,String ok,Event evtOk,String cancel,Event evtCancel) {
		notify = c;
		cancelbutton = new Button(cancel);
		cancelevent = evtCancel;
		cancelevent.target = this;
		okbutton = new Button(ok);
		okevent = evtOk;
		okevent.target = this;
		Panel p = new Panel();
		p.setLayout( new FlowLayout( FlowLayout.CENTER ) );
		p.add(okbutton);
		p.add(cancelbutton);
		add("South",p);
	}

	/**
	 * Constructs a new SmartFrame. The Frame will be shown.
	 * The Component will be displayed in the Frame and an
	 * OK-Button will be added.
	 */
	public SmartFrame(Component comp, String ok) {
		notify = null;

		// This is interesting here. First I used a BorderLayout
		// with a componen in the North, and the OK-button
		// in the south. With Win95 the North was half offscreen!!!!

		setLayout( new VertLayout( VertLayout.STRETCH ) );
		Panel okpanel = new Panel();
		okpanel.setLayout( new FlowLayout( FlowLayout.CENTER ) );
		okbutton = new Button( ok );
		okpanel.add( okbutton );

		add( comp );
		add( okpanel );
		setTitle( "Information" );
		pack();
		show();
	}

	/** 
	 * calls SmartFrame( new Label(msg), ok );
	 */
	public SmartFrame(String msg, String ok) {
		this( new Label( msg, Label.CENTER ), ok );
	}

	/** 
	 * calls SmartFrame( msg, "OK" );
	 */
	public SmartFrame(String msg) {
		this( msg, "OK" );
	}

	public boolean handleEvent(Event evt) {
		if (notify != null) {
			if (evt.target == okbutton) {
				notify.handleEvent(okevent);
				return true;
			}
			if (evt.target == cancelbutton) {
				notify.handleEvent(cancelevent);
				return true;
			}
			if (notifyall)
				if (notify.handleEvent(evt)) return true;
		}
		if (evt.id == Event.WINDOW_DESTROY || evt.target == okbutton) {
			hide();
			dispose();
			return true;

		}
		else return false;
		}
}
