/*

ScrollPanel.java    1996 Jan Kautz

You can scroll a panel in vertical direction.
Horizontally it gets as large as it may get.
Only use in a BorderLayout() as "Center".
After you added a new component to subject,
you can call redo(), and everything will be
fine.

Based on ScrollingPanel, done by Peris Brodsky (plb@idm.com).
*/

package como.awt;

import como.util.*;
import java.util.*;
import java.awt.*;

public class ScrollPanel extends Panel {

	Component subject;
	Portal portal;
	Scrollbar hbar, vbar;
	Dimension subject_dim;
	int hpos, vpos;
	float line_fraction;
	boolean configed = false;
	boolean useinsets;

	public ScrollPanel( Component subject, float line_fraction ) {
		this( subject, line_fraction, true );
	}

	public ScrollPanel( Component subject, float line_fraction, boolean useinsets ) {
		this.subject =  subject;
		this.line_fraction =  line_fraction;
		this.useinsets = useinsets;

		setLayout(new BorderLayout());
     
		portal = new Portal(this, subject);
		portal.setLayout(null);
		add("Center", portal);
		portal.add(subject);
     
		/*
		hbar =  new Scrollbar(Scrollbar.HORIZONTAL);
		add("South", hbar);
		*/
     
		vbar =  new Scrollbar(Scrollbar.VERTICAL);
		add("West", vbar);
	}

	public Insets insets() {
		Insets i = super.insets();

		if( useinsets )
			return new Insets( i.top, i.left+5, i.bottom, i.right+5 );
		else
			return i;
	}

	public void redo()
	{
		configed = false;

		paintAll( getGraphics() );
		subject.paintAll( subject.getGraphics() );

// JK neu
	
		reconfigure( portal.size() );
	}
	
	private void move_subject(int x, int y) {
		subject.move(hpos =  x, vpos =  y);
	}

	public boolean handleEvent(Event e) {
/*
		if (e.target == hbar &&
			(e.id == Event.SCROLL_ABSOLUTE ||
			 e.id == Event.SCROLL_PAGE_UP ||
			 e.id == Event.SCROLL_PAGE_DOWN ||
			 e.id == Event.SCROLL_LINE_UP ||
			 e.id == Event.SCROLL_LINE_DOWN)) {
			move_subject(-((Integer)e.arg).intValue(), vpos);
		}
*/
		if (e.target == vbar &&
			(e.id == Event.SCROLL_ABSOLUTE ||
			 e.id == Event.SCROLL_PAGE_UP ||
			 e.id == Event.SCROLL_PAGE_DOWN ||
			 e.id == Event.SCROLL_LINE_UP ||
			 e.id == Event.SCROLL_LINE_DOWN)) {
			move_subject(hpos, -((Integer)e.arg).intValue());
		}

		return super.handleEvent(e);
}

	public void reconfigure(Dimension portal_dim) {
		if (portal_dim.width <= 0 || portal_dim.height <= 0)
			return;

		if( !configed || portal_dim.width != subject_dim.width ) {
			subject.resize( portal_dim.width, subject.preferredSize().height );
			subject_dim = subject.size();

			configed = true;
		}

		/* At the moment I need only vbars...
		if (subject_dim.width + hpos < portal_dim.width)
			move_subject(Math.min(0, portal_dim.width - subject_dim.width), vpos);
     
		hbar.setValues(-hpos, portal_dim.width, 0, subject_dim.width - portal_dim.width);
     
		// hbar.setPageIncrement(portal_dim.width);
		// hbar.setLineIncrement(Math.round(line_fraction*portal_dim.width));
		*/
     
		if (subject_dim.height + vpos < portal_dim.height)
			move_subject(hpos, Math.min(0, portal_dim.height - subject_dim.height));
    
// JK neu

		int max =  subject_dim.height;
		int visible = portal_dim.height;

		if( System.getProperty( "os.name", "unknown" ).startsWith( "Windows") )
			vbar.setValues(-vpos, visible, 0, max);
		else
			vbar.setValues(-vpos, visible, 0, max - visible);

		// vbar.setPageIncrement(portal_dim.height);
		// vbar.setLineIncrement(Math.round(line_fraction*portal_dim.height));
	}
} 

class Portal extends Panel {

	ScrollPanel	parent;
	Component subject;

	Portal(ScrollPanel parent, Component subject) {
		this.parent =  parent;
		this.subject = subject;
		setLayout(null);
	}

	public void reshape(int x, int y, int width, int height) {
		super.reshape(x, y, width, height);
		Dimension dim = size();
		parent.reconfigure(dim);
	}

	public Dimension preferredSize() {
		return new Dimension( subject.preferredSize() );
	}

	public Dimension minimumSize() {
		return new Dimension( subject.minimumSize() );
	}
}
