package como.awt;
 
import como.util.*;
import java.util.*;
import java.awt.*;

public class RadioImageButton extends Panel {
	public RadioImageButton() {
		super();

		// this is just the standard layout
		setLayout( new VertLayout() );
	}

	public ImageButton add( String con, Image normal, Image current, int width, int height ) {
		ImageButton i = new ImageButton( normal, current, width, height );

		// use as a switch!
		i.setSwitch( true );

		if( con != null )
			add( con, i );
		else
			add( i );

		return i;
	}

	public ImageButton add( Image normal, Image current, int width, int height ) {
		return add( null, normal, current, width, height );
	}

	public void deselectExcept( int except ) {
		Component comp[] = getComponents();

		for( int i = 0; i < comp.length; i++ ) {
			if( i == except ) continue;

			((ImageButton)comp[i]).setState( false );
		}
	}

	public void switchButtonOn( int i ) {
		Component comp[] = getComponents();

		if( i < comp.length ) {
			deselectExcept( i );
			((ImageButton)comp[i]).setState( true );
		}
	}

	public boolean action( Event evt, Object what ) {
		Component comp[] = getComponents();

		for( int i = 0; i < comp.length; i++ ) {
			if( evt.target == comp[i] ) {
				if( ((ImageButton)comp[i]).getState() == true ) {
					// means button is down
					// switch the other button off.
					deselectExcept( i );

					// now let the others know, that the button
					// was pressed.
	
					if( getParent() != null )
						getParent().postEvent( new Event( this, Event.ACTION_EVENT, new Integer(i) ) );
					
					return true;
				}
				else {
					// means button was already on
					// switch it on again, cause we don't
					// want deselected buttons!

					((ImageButton)comp[i]).setState( true );

					// that means nobody else is interested
					// in this event.
					return true;
				}
			}
		}

		return false;
	}
}
